{% from "components/postgres/pg.jinja" import pg with context %}

include:
    - components.common.locale
    - .xlogs

{% if salt['pillar.get']('data:dbaas:shard_hosts') %}
{% if not salt['pillar.get']('pg-master', salt['pillar.get']('data:pgsync:stream_from')) %}
set-master-pillar:
    postgresql_cmd.set_master:
        - user: admin
        - port: 5432
        - password: {{ salt['pillar.get']('data:config:pgusers:admin:password') }}
        - timeout: {{ salt['pillar.get']('pg-master-timeout', 600) }}
        - require_in:
            - postgresql_cmd: pg-init
{% if salt['pillar.get']('data:use_replication_slots', True) %}
            - postgresql_cmd: create_replication_slot
{% endif %}
{% endif %}
{% endif %}

{% if salt['grains.get']('os') == 'Ubuntu' %}
postmaster.opts:
    file.absent:
        - name: /var/lib/postgresql/{{ pg.version.major }}/data/postmaster.opts
        - require_in:
            - service: postgresql-service
        - onlyif:
            - grep '/var/lib/pgsql' /var/lib/postgresql/{{ pg.version.major }}/data/postmaster.opts
{% endif %}

{% if salt['pillar.get']('data:use_replication_slots', True) %}
create_replication_slot:
    postgresql_cmd.create_replication_slot:
        - name: {{ salt['grains.get']('fqdn')|replace('.', '_')|replace('-', '_') }}
        - user: admin
        - port: 5432
        - password: {{ salt['pillar.get']('data:config:pgusers:admin:password') }}
        - control_path: {{ pg.data }}/global/pg_control
        - require:
            - pkg: postgresql{{ pg.version.short }}-server
            - file: {{ pg.prefix }}/.pgpass
        - require_in:
            - postgresql_cmd: pg-init
{% endif %}

pg-init:
    postgresql_cmd.replica_init:
        - name: {{ pg.data }}
{% if salt['pillar.get']('walg-restore', False) and salt['pillar.get']('data:use_walg', True) %}
        - method: wal-g
{% else %}
        - method: basebackup
        - version_major_num: {{ pg.version.major_num }}
{% endif %}
        - require:
            - file: {{ pg.data }}
            - file: {{ pg.prefix }}/.ssh/authorized_keys
            - file: {{ pg.prefix }}/.pgpass
            - cmd: locale-gen
            - cmd: walg-ready
        - require_in:
            - file: {{ pg.data }}/conf.d/postgresql.conf
            - file: {{ pg.data }}/conf.d/pg_hba.conf

recovery.conf:
    postgresql_cmd.populate_recovery_conf:
        - name: {{ pg.data }}/recovery.conf
        - use_replication_slots: {{ salt['pillar.get']('data:use_replication_slots', True) }}
        - application_name: '{{ salt['grains.get']('id')|replace('.', '_')|replace('-', '_') }}'
        - require:
            - postgresql_cmd: pg-init
            - file: /usr/local/yandex/populate_recovery_conf.py
