{% from "components/postgres/pg.jinja" import pg with context %}

postgresql-stop:
    cmd.run:
        - name: '{{ pg.bin_path }}/psql -c "CHECKPOINT" && {{ pg.bin_path }}/pg_ctl -D {{ pg.data }} -m fast stop -t {{ salt['pillar.get']('data:pgsync:recovery_timeout', '1200') }}'
        - runas: postgres
        - onlyif:
            - '{{ pg.bin_path }}/pg_isready -q'
        - require_in:
            - pkg: postgresql{{ pg.version.short }}-server
            - service: postgresql-service

make-checkpoint-after-restart:
    postgresql_cmd.psql_exec:
        - name: 'CHECKPOINT'
        - require:
            - cmd: postgresql-service
