{% from "components/postgres/pg.jinja" import pg with context %}

include:
    - components.common.locale

postgresql-service:
    service:
        - name: {{ pg.service }}
        - running
        - enable: True
        - require:
            - file: {{ pg.data }}/conf.d/postgresql.conf
            - file: {{ pg.data }}/conf.d/pg_hba.conf
            - file: /var/log/postgresql
            - file: /etc/sysctl.d/postgres.conf
            - cmd: locale-gen
{% if pg.is_replica %}
            - postgresql_cmd: recovery.conf
{% endif %}
{% if salt['pillar.get']('data:pg_ssl', True) %}
            - file: /etc/postgresql/ssl
            - file: /etc/postgresql/ssl/server.crt
            - file: /etc/postgresql/ssl/server.key
            - file: /etc/postgresql/ssl/allCAs.pem
{% endif %}
    cmd.wait:
        - name: '/usr/local/yandex/pg_wait_started.py -w {{ salt['pillar.get']('data:pgsync:recovery_timeout', '1200') }}'
        - runas: postgres
        - require:
            - file: /usr/local/yandex/pg_wait_started.py
            - pkg: python-psycopg2
        - watch:
            - service: postgresql-service
