{% from "components/postgres/pg.jinja" import pg with context %}
scripts-sqls-dir:
    file.directory:
        - name: /usr/local/yandex/sqls
        - makedirs: True
        - user: postgres
        - group: postgres
        - mode: 700

{% if salt['pillar.get']('data:pgbouncer:count', 1) > 1 %}
/usr/local/yandex/sqls/pgbouncer.sql:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/scripts-sql/multiple_pgbouncer.sql
        - user: postgres
        - group: postgres
        - mode: 700
        - require:
            - file: scripts-sqls-dir
{% else %}
/usr/local/yandex/sqls/pgbouncer.sql:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/scripts-sql/pgbouncer.sql
        - user: postgres
        - group: postgres
        - mode: 700
        - require:
            - file: scripts-sqls-dir
{% endif %}

/usr/local/yandex/sqls/monitor_stat_statment.sql:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/scripts-sql/monitor_stat_statment.sql
        - user: postgres
        - group: postgres
        - mode: 700
        - require:
            - file: scripts-sqls-dir

/usr/local/yandex/sqls/repl_mon.sql:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/scripts-sql/repl_mon.sql
        - user: postgres
        - group: postgres
        - mode: 700
        - require:
            - file: scripts-sqls-dir

/usr/local/yandex/sqls/show_activity_stats.sql:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/scripts-sql/show_activity_stats.sql
        - user: postgres
        - group: postgres
        - mode: 700
        - require:
            - file: scripts-sqls-dir

/usr/local/yandex/sqls/bloat_functions.sql:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/scripts-sql/bloat_functions.sql
        - user: postgres
        - group: postgres
        - mode: 700
        - require:
            - file: scripts-sqls-dir

/usr/local/yandex/sqls/unapplied_settings.sql:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/scripts-sql/unapplied_settings.sql
        - user: postgres
        - group: postgres
        - mode: 700
        - require:
            - file: scripts-sqls-dir

/usr/local/yandex/sqls/show_sync_replica.sql:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/scripts-sql/show_sync_replica.sql
        - user: postgres
        - group: postgres
        - mode: 700
        - require:
            - file: scripts-sqls-dir

{% if salt['pillar.get']('data:do_index_repack', False) %}
/usr/local/yandex/sqls/index_bloat.sql:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/scripts-sql/index_bloat.sql
        - user: postgres
        - group: postgres
        - mode: 700
        - require:
            - file: scripts-sqls-dir
{% endif %}

{% if pg.is_master %}
create_pgbouncer_views:
    postgresql_cmd.psql_file:
        - name: /usr/local/yandex/sqls/pgbouncer.sql
        - onchanges:
            - file: /usr/local/yandex/sqls/pgbouncer.sql
        - require:
            - service: postgresql-service

create_monitor_stat_statments:
    postgresql_cmd.psql_file:
        - name: /usr/local/yandex/sqls/monitor_stat_statment.sql
        - onchanges:
            - file: /usr/local/yandex/sqls/monitor_stat_statment.sql
        - require:
            - service: postgresql-service

create_show_activity_stats_function:
    postgresql_cmd.psql_file:
        - name: /usr/local/yandex/sqls/show_activity_stats.sql
        - onchanges:
            - file: /usr/local/yandex/sqls/show_activity_stats.sql
        - require:
            - service: postgresql-service

create_get_unapplied_settings_function:
    postgresql_cmd.psql_file:
        - name: /usr/local/yandex/sqls/unapplied_settings.sql
        - onchanges:
            - file: /usr/local/yandex/sqls/unapplied_settings.sql
        - require:
            - service: postgresql-service

create_show_sync_replica_function:
    postgresql_cmd.psql_file:
        - name: /usr/local/yandex/sqls/show_sync_replica.sql
        - onchanges:
            - file: /usr/local/yandex/sqls/show_sync_replica.sql
        - require:
            - service: postgresql-service

repl-mon-monitor-permission:
    postgresql_cmd.psql_exec:
        - name: 'grant select on repl_mon to monitor'
        - unless:
            - -tA -c "select has_table_privilege('monitor', 'public.repl_mon', 'select');" | grep -q "^t"
        - require:
            - cmd: postgresql-service
            - postgres_user: postgres-user-monitor

{% for db in ['postgres', 'template1'] + salt['grains.get']('pg:databases', []) %}
bloat-info-functions-{{ db }}:
    postgresql_cmd.psql_file:
        - name: /usr/local/yandex/sqls/bloat_functions.sql
        - maintenance_db: {{ db }}
        - unless:
            - -tA -c "select 't' from pg_proc where proname in ('get_index_bloat_info')" | grep -q "^t"
            - -tA -c "select 't' from pg_proc where proname in ('get_heap_bloat_info')" | grep -q "^t"
        - require:
            - cmd: postgresql-service
            - file: /usr/local/yandex/sqls/bloat_functions.sql
{% endfor %}

{% endif %}
