{% from "components/postgres/pg.jinja" import pg with context %}

/etc/{{ pg.connection_pooler }}/ssl:
    file.directory:
        - user: {{ pg.bouncer_user }}
        - group: {{ pg.bouncer_user }}
        - makedirs: True
        - mode: 750
        - require_in:
            - service: {{ pg.connection_pooler }}

/etc/{{ pg.connection_pooler }}/ssl/server.key:
    file.managed:
        - contents_pillar: cert.key
        - template: jinja
        - user: {{ pg.bouncer_user }}
        - group: {{ pg.bouncer_user }}
        - mode: 600
        - require:
            - file: /etc/{{ pg.connection_pooler }}/ssl
        - require_in:
            - service: {{ pg.connection_pooler }}

/etc/{{ pg.connection_pooler }}/ssl/server.crt:
    file.managed:
        - contents_pillar: cert.crt
        - template: jinja
        - user: {{ pg.bouncer_user }}
        - group: {{ pg.bouncer_user }}
        - mode: 600
        - require:
            - file: /etc/{{ pg.connection_pooler }}/ssl
        - require_in:
            - service: {{ pg.connection_pooler }}

/etc/{{ pg.connection_pooler }}/ssl/allCAs.pem:
    file.managed:
        - contents_pillar: cert.ca
        - template: jinja
        - user: {{ pg.bouncer_user }}
        - group: {{ pg.bouncer_user }}
        - mode: 600
        - require:
            - file: /etc/{{ pg.connection_pooler }}/ssl
        - require_in:
            - service: {{ pg.connection_pooler }}

/etc/postgresql/ssl:
    file.directory:
        - user: postgres
        - group: postgres
        - makedirs: True
        - mode: 750

/etc/postgresql/ssl/server.key:
    file.managed:
        - contents_pillar: cert.key
        - template: jinja
        - user: postgres
        - group: postgres
        - mode: 600
        - require:
            - file: /etc/postgresql/ssl
        - require_in:
            - service: postgresql-service

/etc/postgresql/ssl/server.crt:
    file.managed:
        - contents_pillar: cert.crt
        - template: jinja
        - user: postgres
        - group: postgres
        - mode: 600
        - require:
            - file: /etc/postgresql/ssl
        - require_in:
            - service: postgresql-service


/etc/postgresql/ssl/allCAs.pem:
    file.managed:
        - contents_pillar: cert.ca
        - template: jinja
        - user: postgres
        - group: postgres
        - mode: 600
        - require:
            - file: /etc/postgresql/ssl
        - require_in:
            - service: postgresql-service

{{ pg.prefix }}/.postgresql:
    file.directory:
        - user: postgres
        - group: postgres
        - makedirs: True
        - mode: 755

{{ pg.prefix }}/.postgresql/root.crt:
    file.managed:
        - contents_pillar: cert.ca
        - template: jinja
        - user: postgres
        - group: postgres
        - mode: 600
        - require:
            - file: {{ pg.prefix }}/.postgresql

/home/monitor/.postgresql:
    file.directory:
        - user: monitor
        - group: monitor
        - makedirs: True
        - mode: 755

/home/monitor/.postgresql/root.crt:
    file.managed:
        - contents_pillar: cert.ca
        - template: jinja
        - user: monitor
        - group: monitor
        - mode: 600
