{% set users=salt['pillar.get']('data:config:pgusers', {}) %}
{% if salt['pillar.get']('data:use_idm', False) %}
{% for role in ['reader', 'writer'] %}
create-idm-role-{{role}}:
    postgresql_cmd.psql_exec:
        - require:
            - cmd: postgresql-service
        - name: CREATE ROLE {{role}} WITH NOLOGIN NOCREATEDB CONNECTION LIMIT 2
        - unless:
            - -tAX -c "SELECT rolname FROM pg_roles WHERE rolname = '{{role}}'" | egrep -q '^{{role}}$'
{% endfor %}
{% endif %}

{% for user in users.keys() %}
{% if users[user]['create'] %}
postgres-user-{{ user }}:
    postgres_user.present:
        - name: {{ user }}
        - encrypted: True
{% if not users[user].get('grants', []) and users[user].get('origin', 'other') == 'idm' %}
        - login: False
{% else %}
        - login: {{ salt['pillar.get']('data:config:pgusers:' + user + ':login', True) }}
{% endif %}
        - password: {{ users[user]['password']|yaml_encode }}
        - superuser: {{ users[user]['superuser'] }}
        - replication: {{ users[user]['replication'] }}
        - require:
            - cmd: postgresql-service

{% set limit=salt['pillar.get']('data:config:pgusers:' + user + ':conn_limit', -1) %}
postgres-user-{{ user }}-conn-limit:
    postgresql_cmd.psql_exec:
        - name: alter role "{{ user }}" with connection limit {{ limit }}
        - require:
            - postgres_user: postgres-user-{{ user }}
            - file: /root/.pgpass
        - unless:
            - -tA -c "select 'B' || rolconnlimit::text || 'E' from pg_roles where rolname = '{{ user }}'" | grep -q B{{ limit }}E
{% endif %}
{% if salt['pillar.get']('data:use_idm', False) %}
{% for grant in ['reader', 'writer'] %}
set-{{ grant }}-idm-grants-{{ user }}:
{% if grant in users[user].get('grants', []) %}
    postgres_privileges.present:
{% else %}
    postgres_privileges.absent:
{% endif %}
        - name: {{ user }}
        - object_name: {{ grant }}
        - object_type: group
        - require:
            - postgres_user: postgres-user-{{ user }}
{% endfor %}
{% endif %}
{% endfor %}

postgres-lock-timeout:
    postgresql_cmd.psql_exec:
        - name: ALTER ROLE postgres SET lock_timeout TO 0
        - require:
            - file: /root/.pgpass
            - service: postgresql-service
        - unless:
            - -tA -c "SELECT rolconfig FROM pg_roles WHERE rolname = 'postgres'" | grep -q 'lock_timeout=0'

postgres-temp-file-limit:
    postgresql_cmd.psql_exec:
        - name: ALTER ROLE postgres SET temp_file_limit TO -1
        - require:
            - file: /root/.pgpass
            - service: postgresql-service
        - unless:
            - -tA -c "SELECT rolconfig FROM pg_roles WHERE rolname = 'postgres'" | grep -q 'temp_file_limit=-1'

{% if salt['pillar.get']('data:config:pgusers_strict', True) %}
{% for user in salt['grains.get']('pg:users', []) %}
{% if user not in users and user not in ['postgres', 'pg_signal_backend', 'dbaas_auth_user', 'reader', 'writer'] %}
{{ user }}-not-in-pillar:
    postgres_user.present:
        - name: {{ user }}
        - login: False
        - require:
            - cmd: postgresql-service
{% if user == 'pgaas-proxy-auth-user' %}
{{ user }}-drop:
    postgresql_cmd.psql_exec:
        - name: 'revoke ALL on ALL functions in schema public from "pgaas-proxy-auth-user"; revoke CONNECT on DATABASE postgres from "pgaas-proxy-auth-user"; drop role "pgaas-proxy-auth-user";'
        - require:
            - cmd: postgresql-service
{% endif %}
{% endif %}
{% endfor %}
{% endif %}

{% set dbmap = {} %}
{% set unmanaged_map = {} %}
{% for database in (salt['grains.get']('pg:databases', []) + ['postgres']) %}
{% do dbmap.update({database: True}) %}
{% endfor %}
{% for database in salt['pillar.get']('data:unmanaged_dbs', []) %}
{% do dbmap.update({database.keys()[0]: True}) %}
{% do unmanaged_map.update({database.keys()[0]: True}) %}
{% endfor %}

{% for database in (['template1'] + dbmap.keys()|sort) %}
{{ database }}-drop-public-access:
    postgresql_cmd.psql_exec:
        - name: grant connect on database "{{ database }}" to postgres; revoke connect on database "{{ database }}" from public
        - maintenance_db: {{ database }}
        - require:
{% if database in unmanaged_map %}
            - postgres_database: create_db_{{ database }}
{% endif %}
            - service: postgresql-service
        - unless:
            - -tA -c "SELECT * FROM has_database_privilege('public', '{{ database }}', 'connect')" | grep -q f
{% if pillar.get('restore-from:cid') %}
{# ugly workaround for restore, cause we rename database when restore it #}
            - /bin/true
{% endif %}

{% for user in users %}
{% if users[user].get('create', False) %}
{% if database in users[user].get('connect_dbs', []) or '*' in users[user].get('connect_dbs', []) %}
{{ database }}-{{ user }}-grant-connect:
    postgresql_cmd.psql_exec:
        - name: grant connect on database "{{ database }}" to "{{ user }}"
        - maintenance_db: {{ database }}
        - require:
            - service: postgresql-service
            - postgres_user: postgres-user-{{ user }}
{% if database in unmanaged_map %}
            - postgres_database: create_db_{{ database }}
{% endif %}
        - require_in:
            - cmd: {{ database }}-drop-public-access
        - unless:
            - -tA -c "SELECT * FROM has_database_privilege('{{ user }}', '{{ database }}', 'connect')" | grep -q t
            - -tA -c "SELECT * FROM has_database_privilege('public', '{{ database }}', 'connect')" | grep -q f
{% if pillar.get('restore-from:cid') %}
{# ugly workaround for restore, cause we rename database when restore it #}
            - /bin/true
{% endif %}
{% endif %}
{% endif %}
{% endfor %}
{% endfor %}


{% if salt['pillar.get']('data:under_sox_audit', False) == True %}
{% set roles = ['postgres', ] %}

{% if salt['pillar.get']('data:use_idm', False) %}
{% do roles.append('writer') %}
{% endif %}

{% for user in users.keys() %}
{% if users[user]['superuser'] %}
{% do roles.append(user) %}
{% endif %}
{% endfor %}

{% for user in roles %}
{{ user }}-enable-statements-logging:
    postgresql_cmd.psql_exec:
        - name: ALTER ROLE "{{ user }}" SET log_statement TO 'mod'
        - require:
            - file: /root/.pgpass
            - service: postgresql-service
        - unless:
            - -tA -c "SELECT rolconfig FROM pg_roles WHERE rolname = '{{ user }}'" | grep -q 'log_statement=mod'
{% endfor %}
{% endif %}
