{% from "components/postgres/pg.jinja" import pg with context %}
{% set gpg_key_id = salt['pillar.get']('data:s3:gpg_key_id', salt['grains.get']('pg:suffix', grains['id'])) %}

include:
    - .gpg

walg-packages:
    pkg.installed:
        - pkgs:
            - wal-g: {{ salt['pillar.get']('data:walg:version', '458-b055370') }}
            - daemontools
            - python3-dateutil
{% if salt['pillar.get']('yandex:environment', 'prod') != 'prod' %}
            - yandex-internal-root-ca
{% endif %}
        - require_in:
            - service: postgresql-service

/etc/wal-g/envdir:
    file.directory:
        - user: root
        - group: s3users
        - mode: 0750
        - makedirs: True
        - require:
            - group: s3users

/etc/wal-g/envdir/AWS_ACCESS_KEY_ID:
    file.managed:
        - user: root
        - group: s3users
        - mode: 640
        - contents_pillar: data:s3:access_key_id
        - require:
            - pkg: walg-packages
            - file: /etc/wal-g/envdir
        - require_in:
            - service: postgresql-service

/etc/wal-g/envdir/AWS_SECRET_ACCESS_KEY:
    file.managed:
        - user: root
        - group: s3users
        - mode: 640
        - contents_pillar: data:s3:access_secret_key
        - require:
            - pkg: walg-packages
            - file: /etc/wal-g/envdir
        - require_in:
            - service: postgresql-service

/etc/wal-g/envdir/WALG_DELTA_MAX_STEPS:
    file.managed:
        - user: root
        - group: s3users
        - mode: 640
        - contents: {{ salt['pillar.get']('data:walg:delta_max_steps', 6) | int}}
        - require:
            - pkg: walg-packages
            - file: /etc/wal-g/envdir
        - require_in:
            - service: postgresql-service

{% set walg_coroutines = salt['pillar.get']('data:walg:walg_coroutines', 8) %}
{% set walg_threads = walg_coroutines + 1 %}

/etc/wal-g/envdir/GOMAXPROCS:
    file.managed:
        - user: root
        - group: s3users
        - mode: 640
        - contents: {{ walg_threads | int }}
        - require:
            - pkg: walg-packages
            - file: /etc/wal-g/envdir
        - require_in:
            - service: postgresql-service

/etc/wal-g/envdir/GOMAXPROC:
    file.absent

/etc/wal-g/envdir/WALG_DOWNLOAD_CONCURRENCY:
    file.managed:
        - user: root
        - group: s3users
        - mode: 640
        - contents: {{ walg_coroutines | int }}
        - require:
            - pkg: walg-packages
            - file: /etc/wal-g/envdir
        - require_in:
            - service: postgresql-service

/etc/wal-g/envdir/WALG_UPLOAD_CONCURRENCY:
    file.managed:
        - user: root
        - group: s3users
        - mode: 640
        - contents: {{ walg_coroutines | int }}
        - require:
            - pkg: walg-packages
            - file: /etc/wal-g/envdir
        - require_in:
            - service: postgresql-service

/etc/wal-g/envdir/WALG_COMPRESSION_METHOD:
    file.managed:
        - contents: {{ salt['pillar.get']('data:walg:compression_method', 'lz4') }}
        - user: root
        - group: s3users
        - mode: 640
        - require:
            - pkg: walg-packages
            - file: /etc/wal-g/envdir
        - require_in:
            - service: postgresql-service

/etc/wal-g/envdir/PGHOST:
    file.managed:
        - user: root
        - group: s3users
        - mode: 640
        - contents: '/var/run/postgresql'
        - require:
            - pkg: walg-packages
            - file: /etc/wal-g/envdir
        - require_in:
            - service: postgresql-service

/etc/wal-g/envdir/PATH:
    file.managed:
        - user: root
        - group: s3users
        - mode: 640
        - contents: '/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin:/usr/lib/postgresql/9.6/bin'
        - require:
            - pkg: walg-packages
            - file: /etc/wal-g/envdir
        - require_in:
            - service: postgresql-service

/etc/wal-g/envdir/AWS_ENDPOINT:
    file.managed:
        - user: root
        - group: s3users
        - mode: 640
        - contents: {{ salt['pillar.get']('data:s3:endpoint', 'https://s3.mds.yandex.net/').replace('https+path','https').replace('http+path','http') }}
        - require:
            - pkg: walg-packages
            - file: /etc/wal-g/envdir
        - require_in:
            - service: postgresql-service

/etc/wal-g/envdir/WALE_LOG_DESTINATION:
    file.managed:
        - user: root
        - group: s3users
        - mode: 640
        - contents: syslog
        - require:
            - pkg: walg-packages
            - file: /etc/wal-g/envdir
        - require_in:
            - service: postgresql-service

/etc/wal-g/envdir/WALE_S3_PREFIX:
    file.managed:
        - user: root
        - group: s3users
        - mode: 640
        - contents: |
            s3://{{ salt['pillar.get']('data:s3_bucket', 'mdb') }}/wal-e/{{ salt['pillar.get']('data:dbaas:cluster_id', salt['grains.get']('pg:suffix', grains['id'])) }}/{{ pg.version.major_num }}/
        - require:
            - pkg: walg-packages
            - file: /etc/wal-g/envdir
        - require_in:
            - service: postgresql-service

/etc/wal-g/envdir/WALE_GPG_KEY_ID:
    file.managed:
        - user: root
        - group: s3users
        - mode: 640
        - contents: |
            {{ salt['pillar.get']('data:s3:gpg_key_id', salt['grains.get']('pg:suffix', grains['id'])) }}
        - require:
            - pkg: walg-packages
            - file: /etc/wal-g/envdir
        - require_in:
            - service: postgresql-service

/etc/wal-g/envdir/AWS_S3_FORCE_PATH_STYLE:
    file.managed:
        - user: root
        - group: s3users
        - mode: 640
        - contents: |
            {{ (not salt['pillar.get']('data:s3:virtual_addressing_style', False)) | json }}
        - require:
            - pkg: walg-packages
            - file: /etc/wal-g/envdir
        - require_in:
            - service: postgresql-service

{% if salt['pillar.get']('data:s3:region') %}
/etc/wal-g/envdir/AWS_REGION:
    file.managed:
        - user: root
        - group: s3users
        - mode: 640
        - contents_pillar: data:s3:region
        - require:
            - pkg: walg-packages
            - file: /etc/wal-g/envdir
        - require_in:
            - service: postgresql-service
            - cmd: walg-ready
{% endif %}

/etc/wal-g-backup-push.conf:
    file.managed:
        - source: salt://{{ slspath }}/conf/wal-g-backup-push.conf
        - template: jinja
        - mode: 644

/usr/local/yandex/pg_walg_backup_push.py:
    file.managed:
        - source: salt://{{ slspath }}/conf/pg_walg_backup_push.py
        - user: root
        - group: root
        - mode: 755
        - require:
            - file: /usr/local/yandex

/etc/cron.d/pg_walg_backup_push:
    file.managed:
        - source: salt://{{ slspath }}/conf/cron.d/pg_walg_backup_push
        - template: jinja
        - mode: 644
        - watch_in:
            - service: pg-common-configs-crond-reload

{% if not salt['pillar.get']('data:use_wale', False) %}
{# WAL-E will take out his cron on his own #}
/etc/cron.d/pg_wale_backup_push:
    file.absent
{% endif %}

s3users:
    group.present:
        - members:
            - postgres
            - monitor
        - system: True
        - require:
            - file: {{ pg.data }}
            - pkg: yamail-monrun
        - require_in:
            - service: postgresql-service

{% set walg_lock_file = '/tmp/pg_walg_backup_push.lock' %}

{% if salt['pillar.get']('do-backup') %}
do_s3_backup:
    cmd.run:
        - name: >
            flock -o {{ walg_lock_file }}
            /usr/local/yandex/pg_walg_backup_push.py
            -d {{ pg.data }}
            --strict
            --skip-delete-old
        - runas: postgres
        - require:
            - service: postgresql-service
{% endif %}

{% if salt['pillar.get']('restore-from:cid') %}

restore-from-pillar-data-exists-in-pillar:
    test.check_pillar:
        - dictionary:
            - data:restore-from-pillar-data

/etc/wal-g/envdir-for-restore:
    file.directory:
        - user: root
        - group: s3users
        - mode: 0750
        - makedirs: True
        - require:
            - group: s3users
            - test: restore-from-pillar-data-exists-in-pillar

{% for env_file_name in [
    'AWS_ACCESS_KEY_ID', 'AWS_SECRET_ACCESS_KEY', 'WALG_DELTA_MAX_STEPS',
    'PGHOST', 'PATH', 'AWS_ENDPOINT',
    'WALE_LOG_DESTINATION', 'AWS_S3_FORCE_PATH_STYLE',
    'GOMAXPROC', 'WALG_DOWNLOAD_CONCURRENCY', 'WALG_UPLOAD_CONCURRENCY'] %}

/etc/wal-g/envdir-for-restore/{{ env_file_name }}:
    file.symlink:
        - target: /etc/wal-g/envdir/{{ env_file_name }}
        - user: root
        - group: s3users
        - mode: 640
        - require:
            - pkg: walg-packages
            - file: /etc/wal-g/envdir-for-restore
            - file: /etc/wal-g/envdir/{{ env_file_name }}
        - require_in:
            - cmd: backup-fetched

{% endfor %}

{% if salt['pillar.get']('data:s3:region') %}
/etc/wal-g/envdir-for-restore/AWS_REGION:
    file.symlink:
        - target: /etc/wal-g/envdir/AWS_REGION
        - user: root
        - group: s3users
        - mode: 640
        - require:
            - pkg: walg-packages
            - file: /etc/wal-g/envdir-for-restore
            - file: /etc/wal-g/envdir/AWS_REGION
        - require_in:
            - cmd: backup-fetched
{% endif %}

{# here come files, not links #}

/etc/wal-g/envdir-for-restore/WALE_S3_PREFIX:
    file.managed:
        - user: root
        - group: s3users
        - mode: 640
        - contents: |
            s3://{{ salt['pillar.get']('data:restore-from-pillar-data:s3_bucket', 'mdb') }}/wal-e/{{ salt['pillar.get']('restore-from:cid') }}/{{ pg.version.major_num }}
        - require:
            - pkg: walg-packages
            - file: /etc/wal-g/envdir-for-restore
        - require_in:
            - cmd: backup-fetched

/etc/wal-g/envdir-for-restore/WALE_GPG_KEY_ID:
    file.managed:
        - user: root
        - group: s3users
        - mode: 640
        - contents: |
            {{ salt['pillar.get']('data:restore-from-pillar-data:s3:gpg_key_id') }}
        - require:
            - pkg: walg-packages
            - file: /etc/wal-g/envdir-for-restore
            - cmd: drop-existing-keyrings
            - cmd: import-gpg-restore-from-key
            - cmd: trust-all-imported-keys
        - require_in:
            - cmd: backup-fetched

restore-from-pillar-contains-backup-id:
    test.check_pillar:
        - string:
            - restore-from:backup-id

backup-fetched:
    cmd.run:
        - name: >
            rm -rf {{ pg.data }} &&
            envdir /etc/wal-g/envdir-for-restore/
            wal-g backup-fetch {{ pg.data }} {{ salt['pillar.get']('restore-from:backup-id') }} &&
            touch /tmp/recovery-state/backup-fetched
        - runas: postgres
        - require:
            - file: /tmp/recovery-state
            - test: restore-from-pillar-contains-backup-id
        - require_in:
            - file: {{ pg.data }}/wals
            - file: {{ pg.data }}/conf.d
        - unless:
            - ls /tmp/recovery-state/backup-fetched

remove-keys-when-postgres-restored:
    cmd.run:
        - name: rm -rf /etc/wal-g/envdir-for-restore
        - require:
            - cmd: postgresql-restore

{% endif %}


{% if salt['pillar.get']('data:walg:internal_pgp', True) %}
/etc/wal-g/PGP_KEY:
    file.managed:
        - user: root
        - group: s3users
        - mode: 640
        - contents_pillar: gpg-yav-secrets:armored.gpg
        - require:
            - pkg: walg-packages
            - file: /etc/wal-g/envdir
        - require_in:
            - service: postgresql-service

/etc/wal-g/envdir/WALG_PGP_KEY_PATH:
    file.managed:
        - user: root
        - group: s3users
        - mode: 640
        - contents: '/etc/wal-g/PGP_KEY'
        - require:
            - pkg: walg-packages
            - file: /etc/wal-g/envdir
            - file: /etc/wal-g/PGP_KEY
        - require_in:
            - cmd: walg-ready
{% endif %}

walg-ready:
    cmd.run:
        - name: echo "wal-g ready"
        - require:
            - /etc/wal-g/envdir/AWS_ACCESS_KEY_ID
            - /etc/wal-g/envdir/AWS_SECRET_ACCESS_KEY
            - /etc/wal-g/envdir/WALG_DELTA_MAX_STEPS
            - /etc/wal-g/envdir/GOMAXPROCS
            - /etc/wal-g/envdir/GOMAXPROC
            - /etc/wal-g/envdir/WALG_DOWNLOAD_CONCURRENCY
            - /etc/wal-g/envdir/WALG_UPLOAD_CONCURRENCY
            - /etc/wal-g/envdir/WALG_COMPRESSION_METHOD
            - /etc/wal-g/envdir/PGHOST
            - /etc/wal-g/envdir/PATH
            - /etc/wal-g/envdir/AWS_ENDPOINT
            - /etc/wal-g/envdir/AWS_S3_FORCE_PATH_STYLE
            - /etc/wal-g/envdir/WALE_LOG_DESTINATION
            - /etc/wal-g/envdir/WALE_S3_PREFIX
            - /etc/wal-g/envdir/WALE_GPG_KEY_ID
        - onchanges:
            -  walg-packages
