{% from "components/postgres/pg.jinja" import pg with context %}
{% set pg_resetup_separate_wal_flag = salt['pillar.get']('data:pg_resetup_separate_wal_flag', '/tmp/.pg_resetup_separate_wal.flag') %}

umount_array_for_xlogs:
    cmd.run:
        - name: umount {{ pg.wal_dir_path }}
        - require_in:
            - postgresql_cmd: pg-init
        - onlyif:
            - fgrep {{ pg.wal_dir_path }} /proc/mounts
            - ls {{ pg_resetup_separate_wal_flag }}
        - unless:
            - ls {{ pg.data }}/base
        - onchages:
            - file: umount_array_for_xlogs
    file.absent:
        - name: {{ pg.wal_dir_path }}
        - require_in:
            - postgresql_cmd: pg-init
        - unless:
            - ls {{ pg.data }}/base
        - onlyif:
            - ls {{ pg_resetup_separate_wal_flag }}

remount_array_for_xlogs:
    cmd.run:
        - name: 'mkdir -p /tmp/backupxlogs; mv {{ pg.wal_dir_path }}/* /tmp/backupxlogs/'
        - runas: postgres
        - require:
            - cmd: umount_array_for_xlogs
            - postgresql_cmd: pg-init
        - unless:
            - fgrep {{ pg.wal_dir_path }} /proc/mounts
        - onlyif:
            - ls {{ pg.wal_dir_path }}/*
            - ls {{ pg_resetup_separate_wal_flag }}

    mount.mounted:
        - name: {{ pg.wal_dir_path }}
        - device: {{ salt['pillar.get']('data:array_for_xlogs', '/dev/md3')}}
        - fstype: ext4
        - opts: noatime,nodiratime
        - persist: True
        - pass_num: 1
        - require:
            - cmd: remount_array_for_xlogs
        - unless:
            - fgrep {{ pg.wal_dir_path }} /proc/mounts
        - onlyif:
            - ls {{ pg_resetup_separate_wal_flag }}

restore_xlogs:
    file.directory:
        - name: {{ pg.wal_dir_path }}
        - user: postgres
        - group: postgres
        - mode: 0700
        - require_in:
            - cmd: restore_xlogs
        - require:
            - mount: remount_array_for_xlogs
    cmd.run:
        - name: mv /tmp/backupxlogs/* {{ pg.wal_dir_path }}/
        - runas: postgres
        - require_in:
            - service: postgresql-service
        - onlyif:
            - ls /tmp/backupxlogs/*
            - ls {{ pg_resetup_separate_wal_flag }}

clean_resetup_flag:
    file.absent:
        - name: {{ pg_resetup_separate_wal_flag }}
        - require:
            - cmd: restore_xlogs
        - onlyif:
            - ls {{ pg_resetup_separate_wal_flag }}
