{% if salt['grains.get']('os') == 'Ubuntu' %}
{% set prefix = '/usr/local' %}
{% else %}
{% set prefix = '/opt' %}
{% endif %}

yasmagent-instance-getter:
    file.managed:
        - name: {{ prefix }}/yasmagent/mail_postgresql_getter.py
        - template: jinja
        - source: salt://{{ slspath }}/conf/yasm-agent.getter.py
        - makedirs: True
        - mode: 755
        - defaults:
            instances: {{ salt['pillar.get']('data:yasmagent:instances', ['mailpostgresql'])|join(',') }}
{% if salt['pillar.get']('data:use_yasmagent', True) %}
        - require:
            - pkg: yasmagent-packages

yasmagent-packages:
    pkg.installed:
        - pkgs:
            - yandex-yasmagent: 2.444-20200812

yasmagent-config:
    file.managed:
        - name: {{ prefix }}/yasmagent/CONF/agent.mailpostgresql.conf
        - template: jinja
        - source: salt://{{ slspath }}/conf/yasm-agent.mailpostgresql.conf
        - mode: 644
        - user: monitor
        - group: monitor
        - require:
            - pkg: yasmagent-packages
            - file: yasmagent-init
            - file: yasmagent-instance-getter
            - file: yasmagent-default-config

yasmagent-init:
    file.managed:
        - name: /etc/init.d/yasmagent
        - template: jinja
        - source: salt://{{ slspath }}/conf/yasm-agent.ubuntu.init
        - mode: 755
        - require:
            - pkg: yasmagent-packages

yasmagent-default-config:
    file.managed:
        - name: /etc/default/yasmagent
        - template: jinja
        - source: salt://{{ slspath }}/conf/yasm-agent.default
        - mode: 644

yasmagent-restart:
    service:
        - running
        - enable: true
        - name: yasmagent
        - watch:
            - pkg: yasmagent-packages
            - file: yasmagent-config
            - file: yasmagent-instance-getter
            - file: yasmagent-default-config
            - file: yasmagent-init

/etc/cron.d/yandex-yasmagent:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/cron.d/yandex-yasmagent
        - mode: 644
{% else %}
        - require:
            - pkg: yandex-yasmagent

yandex-yasmagent:
    pkg.purged
{% endif %}
