pushclient:
    pkg.installed:
        - name: yandex-push-client
        - version: '6.63.0'
    service:
        - running
        - enable: true
        - name: statbox-push-client
        - sig: '/usr/bin/push-client -f -w --pid /var/run/statbox/push-client.pid'
        - watch:
            - pkg: pushclient
            - file: /etc/yandex/statbox-push-client/push-client.yaml
            - file: /etc/default/push-client
            - group: statbox-in-adm-group
        - require:
            - pkg: pushclient
            - user: statbox-user
            - group: statbox-in-adm-group
            - file: /var/spool/push-client
            - file: /var/log/statbox

/etc/yandex/statbox-push-client/push-client.yaml:
    file.managed:
        - source: salt://{{ slspath }}/conf/push-client.yaml
        - template: jinja
        - makedirs: True
        - mode: 640
        - user: statbox
        - group: monitor
        - require:
            - pkg: pushclient

pushclient-logrotate:
    pkg.installed:
        - name: config-logrotate-push-client
        - version: 1.0.1

/etc/default/push-client:
    file.managed:
        - source: salt://{{ slspath }}/conf/default
        - template: jinja
        - makedirs: True
        - require:
            - pkg: pushclient

statbox-user:
  user.present:
    - name: statbox
    - gid_from_name: True
    - createhome: True
    - home: /var/lib/push-client
    - empty_password: True
    - shell: /bin/sh
    - system: True

statbox-in-adm-group:
    group.present:
        - name: adm
        - addusers:
            - statbox
        - system: True
        - require:
            - user: statbox-user

/var/spool/push-client:
    file.directory:
        - user: statbox
        - group: statbox
        - makedirs: True
        - require:
            - pkg: pushclient
            - user: statbox-user

/var/log/statbox:
    file.directory:
        - user: statbox
        - group: statbox
        - makedirs: True
        - require:
            - pkg: pushclient
            - user: statbox-user

pushclient-monitoring:
    pkg.installed:
        - name: config-monrun-push-client-mobile
        - version: 1.0.2


/usr/local/bin/push-client_logs_status.py:
    file.managed:
        - source: salt://{{ slspath }}/conf/push-client_logs_status.py
        - template: jinja
        - mode: 755
        - makedirs: True

/etc/monrun/conf.d/push-client_logs_status.conf:
    file.managed:
        - source: salt://{{ slspath }}/conf/monrun_push-client_logs_status.conf
        - makedirs: True
        - require:
            - file: /usr/local/bin/push-client_logs_status.py
        - watch_in:
            - cmd: monrun-jobs-update

include:
    - components.monrun2
