'docker-repo':
    pkgrepo.managed:
        - refresh: false
        - watch_in:
            - cmd: apt-get-qq-update
        - require_in:
            - cmd: apt-get-qq-update
        - name: 'deb [arch=amd64] https://download.docker.com/linux/ubuntu trusty stable'
        - file: /etc/apt/sources.list.d/docker.list
        - require:
            - pkg: apt-transport-https
            - pkg: unbound-config-local64
            - file: docker-repo-gpg-key

docker-repo-gpg-key:
    file.managed:
        - name: /etc/apt/trusted.gpg.d/docker.gpg
        - source: salt://{{ slspath + '/conf/gpg.key' }}

apt-transport-https:
    pkg.installed

include:
    - components.repositories.apt
