#!/usr/bin/env python
import psycopg2

def in_recovery(connection):
    cur = connection.cursor()
    cur.execute("SHOW transaction_read_only;")
    if cur.fetchone()[0] == 'off':
        return False
    return True

def main():
    conn = psycopg2.connect('dbname=sharddb connect_timeout=1')
    conn.set_isolation_level(psycopg2.extensions.ISOLATION_LEVEL_AUTOCOMMIT)
    if in_recovery(conn):
        return None
    cur = conn.cursor()
    cur.execute("SELECT gid FROM pg_prepared_xacts WHERE prepared < now() - INTERVAL '6 minutes'")
    for (xact_gid,) in cur.fetchall():
        if 'reg_sharddb_u' in xact_gid:
           cur.execute('ROLLBACK PREPARED %s;', (xact_gid,))
    cur.close()
    conn.close()
     
if __name__ == '__main__':
    main()
