import logging
import sys


class Hook(object):
    def __init__(self, cluster):
        self.log = logging.getLogger('sharpei-hook')
        self.cluster = cluster

    def _close_sharpei(self, hostname):
        res = self.cluster.ssh('root', hostname, 'sharpei-closer hide; sleep 30')
        if res[0] != 0:
            self.log.error('Unable close %s from balancer' % hostname)
            sys.exit(1)

    def _open_sharpei(self, hostname):
        res = self.cluster.ssh('root', hostname, 'sharpei-closer unhide')
        if res[0] != 0:
            self.log.error('Unable open %s to balancer' % hostname)
            sys.exit(1)

    def beforeSettingsCheck(self):
        pass

    def beforeMasterStop(self):
{% if salt['pillar.get']('data:sharpei:cascade', False) %}
        for i in self.cluster.get_cluster_hostnames():
            if '01' not in i:
                self.log.warning('Removing ' + i + ' from replicas list')
                self.cluster.replicas.remove(i)
        if self.cluster.repl_slot_names:
            slots = self.cluster.repl_slot_names[:]
            for i in slots:
                if '01' not in i:
                    self.log.warning('Ignore slot ' + i)
                    self.cluster.repl_slot_names.remove(i)
{% endif %}

        self._close_sharpei(self.cluster.master)

    def beforeLocalPromotion(self):
        pass

    def beforeMasterAttach(self):
        pass

    def beforeOtherAttachAll(self):
        self._open_sharpei(self.cluster.master)

    def beforeOtherAttachEach(self, host):
        self._close_sharpei(host)

    def afterOtherAttachEach(self, host):
        self._open_sharpei(host)

    def afterOtherAttachAll(self):
        pass
