#!/usr/bin/python -u
# -*- coding: utf-8 -*-
import sys

TSKV_OUTPUT = (
    '%(x)s;%(y)s;%(z)s;tskv\ttskv_format={0}\t'
    'timestamp=%(date)s %(time)s\ttimezone=+0300\t'
    '%(message)s'
).format(sys.argv[1])


previous_line = ''

while True:
    try:
        line = sys.stdin.readline()
        line = line.strip()
        if not line:
            if previous_line:
                print(previous_line)
            break

        x, y, z, line = line.split(';', 3)
        if not line.startswith('['):
            _, _, _, previous_line = previous_line.split(';', 3)
            previous_line = "%s;%s;%s;%s\\n%s" % (x, y, z, previous_line, line.rstrip(']').replace('\t', '\\t'))
            continue

        date, time, text = line.split(' ', 2)
        date = date.lstrip('[')
        time = time.rstrip(']')
        message = []
        merge = False
        for kv_part in text.split():
            if merge:
                message[-1] += ' '
                if kv_part.endswith(']'):
                    kv_part = kv_part[:-1]
                    merge = False
                message[-1] += kv_part
                continue
            if '=[' in kv_part:
                kv_part = kv_part.replace('=[', '=')
                merge = True
            elif '=' not in kv_part:
                kv_part = 'reason=' + kv_part
                merge = True
            message.append(kv_part)

        if previous_line:
            print(previous_line)
        previous_line = TSKV_OUTPUT % dict(x=x, y=y, z=z, date=date, time=time, message='\t'.join(message))
    except (ValueError, IndexError, KeyError, TypeError):
        continue
