#!/usr/bin/env python

import json

import psycopg2
import requests


def main():
    try:
        stat_request = requests.get('http://localhost:9999/stat?force=1')
        stat_request.raise_for_status()
        stat = stat_request.json()
        connection = psycopg2.connect('dbname=sharddb user=monitor connect_timeout=1')
        cur = connection.cursor()
        cur.execute("SELECT shard_id, reg_weight FROM shards.scopes_by_shards")
        reg_weights = {str(shard_id): reg_weight for (shard_id, reg_weight) in cur}
    except Exception:
        return
    else:
        for shard_id, shard_stat in stat.items():
            shard_stat['reg_weight'] = reg_weights.get(shard_id, 0)

        with open('/home/monitor/stat/stat_with_weight.json', 'w') as json_file:
            json.dump(stat, json_file, separators=(',', ':'), sort_keys=True)


if __name__ == '__main__':
    main()
