{% from slspath ~ "/map.jinja" import sharpei with context %}

include:
    - components.graphite.sharpei
    - components.monrun2.sharpei
    - components.monrun2.slb-service
    - components.abyssync
    - .groups
{% if salt['pillar.get']('data:ship_logs', False) %}
    - components.push-client
    - .pushclient
{% endif %}

sharpei-packages:
    pkg.installed:
        - pkgs:
{% for pkg, ver in sharpei.packages.items() %}
            - {{pkg}}: '{{ver}}'
{% endfor %}

sharpei-system-packages:
    pkg.installed:
        - pkgs:
{% for pkg, ver in sharpei.system_packages.items() %}
            - {{pkg}}: '{{ver}}'
{% endfor %}

/etc/sharpei/config.yml:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/config.yml
        - mode: 644
        - user: root
        - group: root
        - require:
            - pkg: sharpei-packages

/etc/nginx/conf.d/sharpei.conf:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/nginx-sharpei.conf
        - mode: 644
        - user: root
        - group: root
        - require:
            - pkg: sharpei-packages

/etc/nginx/nginx.conf:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/nginx.conf
        - mode: 644
        - user: root
        - group: root
        - require:
            - pkg: sharpei-packages

/etc/sharpei-closer.conf:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/sharpei-closer.conf
        - mode: 644
        - user: root
        - group: root
        - require:
            - pkg: sharpei-packages

/etc/rc.conf.local:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/rc.conf.local
        - mode: 644
        - user: root
        - group: root
        - require:
            - pkg: sharpei-packages

/usr/local/yandex/pgswitch/hooks/sharpei.py:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/pgswitch_sharpei.py
        - mode: 644
        - user: root
        - group: root
        - require:
            - pkg: sharpei-packages
            - pkg: yamail-pgswitch

/home/{{sharpei.user}}:
    file.directory:
        - user: {{sharpei.user}}
        - group: {{sharpei.user}}
        - mode: 0700
        - require:
            - pkg: sharpei-packages

/home/{{sharpei.user}}/.pgpass:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/pgpass
        - mode: 600
        - user: {{sharpei.user}}
        - group: {{sharpei.user}}
        - require:
            - file: /home/{{sharpei.user}}

/etc/sysctl.d/sharpei.conf:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/sharpei-sysctl.conf
        - mode: 644
        - require:
            - file: /etc/sysctl.d
    cmd.wait:
        - name: sysctl -p /etc/sysctl.d/sharpei.conf
        - watch:
            - file: /etc/sysctl.d/sharpei.conf

sharpei-restart:
    service:
        - running
        - enable: false
        - name: sharpei
        - watch:
            - pkg: sharpei-packages
            - file: /home/{{sharpei.user}}/.pgpass

nginx-restart:
    service:
        - running
        - enable: true
        - reload: true
        - name: nginx
        - watch:
            - pkg: sharpei-system-packages
            - file: /etc/nginx/conf.d/sharpei.conf
            - file: /etc/nginx/nginx.conf
            - user: nginx-user
            - file: /etc/security/limits.d/90-nginx.conf

nginx-group:
    group.present:
        - name: nginx
        - system: True

nginx-user:
    user.present:
        - name: nginx
        - home: /home/nginx
        - gid_from_name: True
        - createhome: True
        - empty_password: False
        - shell: /bin/bash
        - system: True
        - require:
            - pkg: sharpei-system-packages
            - group: nginx-group

/etc/security/limits.d/90-nginx.conf:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/nginx-limits.conf
        - mode: 644
        - user: root
        - group: root
        - require:
            - pkg: sharpei-system-packages


sharpei-closer-restart:
    service:
        - running
        - enable: true
        - name: sharpei-closer
        - watch:
            - file: /etc/sharpei-closer.conf

/etc/default/sharpei-unistat-daemon:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/sharpei-unistat-daemon.default
        - mode: 644
        - user: root
        - group: root

sharpei-unistat-daemon-restart:
    service:
        - running
        - enable: true
        - name: sharpei-unistat-daemon
        - watch:
            - file: /etc/default/sharpei-unistat-daemon

/etc/logrotate.d/nginx:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/nginx-logrotate
        - mode: 644
        - user: root
        - group: root

/etc/cron.yandex/sharpei-logrotate.sh:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/sharpei-logrotate.sh
        - mode: 755
        - user: root
        - group: root

/home/monitor/stat/:
    file.directory:
        - user: monitor
        - group: monitor

/etc/cron.yandex/sharpei_stat_with_weight.py:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/sharpei_stat_with_weight.py
        - mode: 755
        - user: root
        - group: root

/etc/cron.d/sharpei_stat_with_weight:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/sharpei_stat_with_weight.cron
        - mode: 644
        - user: root
        - group: root

/etc/cron.d/sharpei-logrotate:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/sharpei-logrotate.cron
        - mode: 644
        - user: root
        - group: root

/etc/cron.yandex/end_prepared_transaction.py:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/end_prepared_transaction.py
        - mode: 755
        - user: root
        - group: root

/etc/cron.d/end_prepared_transaction:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/end_prepared_transaction.cron
        - mode: 644
        - user: root
        - group: root

/etc/cron.yandex/sharpei-masters-distribution.py:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/sharpei-masters-distribution.py
        - mode: 755
        - user: root
        - group: root

/etc/cron.d/sharpei-masters-distribution:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/sharpei-masters-distribution.cron
        - mode: 644
        - user: root
        - group: root

{% if salt['grains.get']('virtual', 'physical') == 'lxc' %}
ya-slb-tun-init:
    file.managed:
        - name: /etc/init.d/ya-slb-tun
        - template: jinja
        - source: salt://{{ slspath }}/conf/ya-slb-tun.ubuntu.init
        - mode: 755

ya-slb-tun-restart:
    service:
        - enabled
        - name: ya-slb-tun
        - watch:
            - file: ya-slb-tun-init
{% endif %}
