{# include common components #}
{% for component in salt['pillar.get'](condgroup + ':common:components', {}).keys() %}

{% set component_settings_path = condgroup + ':common:components:' + component %}
{% set component_settings = salt['pillar.get']( component_settings_path, {} ) %}
{% if component_settings == None %}
{% set component_settings = {} %}
{% endif %}

{% include 'components/' + component + '/init.sls' %} 

{% endfor %}
{# include role-specific components #}


{% for role in salt['pillar.get'](condgroup, {}).keys() %}
{% if salt['grains.get']('role:' + role, false) %}
    {% set component = salt['pillar.get'](condgroup + ':' + role + ':components', false) %}
    {% if component != false %}
    {# some modules have settings, e.g. java -- they need to know where tp access them. #}

{% set component_settings_path = condgroup + ':' + role + ':components:' + component.keys()|join %}
{% set component_settings = salt['pillar.get']( component_settings_path, {} ) %}
{% if component_settings == None %}
{% set component_settings = {} %}
{% endif %}

{% include 'components/' + component.keys()|join + '/init.sls' %} 

{% endif %}
{% endif %}
{% endfor %}

