{# We are looking for something like this (in corresponding 'pillar' file):-#} 
{# mail_condgroup:                                                         -#} 
{#     common:                                                             -#} 
{#         ...                                                             -#} 
{#         configs:                                                        -#} 
{#             cron: '/etc/cron.d/wd-app'  <-- this                        -#} 
{#             graphite: '/etc/yabs/graphite-client.cfg' <-- and this      -#} 
{#         ...                                                             -#} 
{#     someapp:                                                            -#} 
{#         ...                                                             -#} 
{#         configs:                                                        -#} 
{#             log4j: '/etc/someapp/log4j.properties' <-- and this         -#} 
{#         ...                                                             -#} 
{#                                                                         -#} 
{# 'configs[]' will look something like this in the end:                   -#} 
{# [                                                                       -#} 
{#     '/etc/cron.d/wd-app',                                               -#} 
{#     '/etc/yabs/graphite-client.cfg',                                    -#} 
{#     '/etc/someapp/log4j.properties'                                     -#} 
{# ]                                                                       -#} 

{# Initialize variable #}
{% set configs = [] -%}
                                         
{# iterate over global config for this conductor group #}
{% for prop in salt['pillar.get'](condgroup, {}).values() %}

    {# iterate over each 'configs' section of each daemon. 'config' is a dictionary. #}
    {# '.get()' method gives a second argument if first wasnt found, #}
    {# and combined with empty dict ('{}') it makes the loop to skip completely. #}
    {% for config in prop.get('configs', {}).values() %}
        
        {# 'for ... else ... endfor' is to prevent duplicates. #}
        {# See 'http://jinja.pocoo.org/docs/templates/#for' #}
        {% for string in configs if string == config %}
        {% else %}
        {% do configs.append(config) %}
        {% endfor %}
    {% endfor %}
{% endfor -%}
{% for config in configs %}

{{ config }}:
    file.managed:
        {# We assume config has a leading slash -#}
        - source: salt://states/{{condgroup}}{{ config }}
        - template: jinja
        - mode: 644
        - makedirs: True
        - user: root
        - group: root
        - defaults:
            condgroup: {{ condgroup }}

{% endfor %}
