{# see explanation in configs.sls #}
{# Initialize variable #}
{% set scripts = [] -%}
                                         
{# iterate over global script for this conductor group #}
{% set roles = salt['pillar.get'](condgroup, {}).values() %}
{% do roles.append('common') %}
{% for role in salt['pillar.get'](condgroup, {}).values() %}

    {# iterate over each 'scripts' section of each daemon. 'script' is a dictionary. #}
    {# '.get()' method gives a second argument if first wasnt found, #}
    {# and combined with empty dict ('{}') it makes the loop to skip completely. #}
    {% for script in role.get('scripts', {}).values() %}
        
        {# 'for ... else ... endfor' is to prevent duplicates. #}
        {# See 'http://jinja.pocoo.org/docs/templates/#for' #}
        {% for string in scripts if string == script %}
        {% else %}
        {% do scripts.append(script) %}
        {% endfor %}
    {% endfor %}
{% endfor -%}
{% for script in scripts %}

{{ script }}:
    file.managed:
        {# We assume script has a leading slash -#}
        - source: salt://states/{{condgroup}}{{ script }}
        - template: jinja
        - mode: 755
        - user: root
        - group: root
        - makedirs: True
        - defaults:
            condgroup: {{ condgroup }}


{% endfor %}
