certificates:
  contents:
  {%- if grains.get('yandex-environment') == 'testing' %}
    loaders.video.yandex.ru.pem: {{ salt.yav.get('sec-01crz6j10s66msgqshgh7k1gp7[pem]') | json }}
  {%- elif grains.get('yandex-environment') in ('stable', 'production') %}
    loaders.video.yandex.ru.pem: {{ salt.yav.get('sec-01crzdkj0rdt387vycecsyhk4c[pem]') | json }}
  {%- else %}
    loaders.video.yandex.ru.pem: {{ salt.yav.get('sec-01crzdn5ggsavq79tn9pbt2dmf[pem]') | json }}
  {%- endif %}

tskv:
  name: 'access-log-video-loader'
  access_log_name: 'access.log'

push_client:
  clean_push_client_configs: True
  port: 8088
  send_delay: 10
  stats:
    - name: stat01d
      logger: { remote: 0 }
    - name: stat01f
      logger: { remote: 0 }
    - name: logbroker
      fqdn: logbroker.yandex.net
      port: default
      server_lite: False
      sszb: False
      proto: rt
      logger: { remote: 0 }
      ident: video
      logs:
        - file: yandex/video/video-service-uploading.log
          log_type: video-service-uploading-log
  logs:
    - file: nginx/access.log
    - file: nginx/error.log
    - file: yandex/video/loader.log

packages:
  cluster:
    - config-media-common
    - config-video-common
    - yandex-3132-fastcgi-loggiver
    - yandex-video-loader
    - yandex-juggler-http-check
    - yandex-crossdomain-xml
