certificates:
  contents:
  {%- if grains.get('yandex-environment') == 'testing' %}
    moderator.video.yandex-team.ru.pem: {{ salt.yav.get('sec-01crz6j10s66msgqshgh7k1gp7[pem]') | json }}
  {%- elif grains.get('yandex-environment') in ('stable', 'production') %}
    moderator.video.yandex-team.ru.pem: {{ salt.yav.get('sec-01crzb7dg5vraqgc9myw3c7azy[pem]') | json }}
  {%- else %}
    moderator.video.yandex-team.ru.pem: {{ salt.yav.get('sec-01crzb9jjrjsk27tccerz4nnbr[pem]') | json }}
  {%- endif %}

tskv:
  name: 'access-log-video-moderator'
  access_log_name: 'access.log'

push_client:
  clean_push_client_configs: True
  port: 8088
  send_delay: 10
  stats:
    - name: stat01d
      logger: { remote: 0 }
    - name: stat01f
      logger: { remote: 0 }
  logs:
    - file: nginx/access.log
    - file: nginx/error.log
    - file: yandex/video/moderator.log

packages:
  cluster:
    - yandex-3132-fastcgi-loggiver
    - yandex-juggler-http-check
    - config-video-common
    - libxscript
    - xscript-corba
    - xscript-daemon
    - xscript-geo
    - xscript-standard
    - xscript-utility
    - xscript-yandex
    - xscript-yandex-sanitizer
    - xscript-multiple-init
    - xscript-yandex-www5
    - xscript-mobile
    - xscript-js
    - xscript-multiple-botlist
    - xscript-multiple-cache-strategies
    - xscript-json
    - iptruler
