certificates:
  contents:
  {%- if grains.get('yandex-environment') == 'testing' %}
    proxy.video.yandex.net.pem: {{ salt.yav.get('sec-01crz6j10s66msgqshgh7k1gp7[pem]') | json }}
  {%- elif grains.get('yandex-environment') in ('stable', 'production') %}
    proxy.video.yandex.net.pem: {{ salt.yav.get('sec-01crzbnxb7757rjzb5ktv7g9bj[pem]') | json }}
  {%- else %}
    proxy.video.yandex.net.pem: {{ salt.yav.get('sec-01crzdg4vp2qvfe9krsgw29g4g[pem]') | json }}
  {%- endif %}

tskv:
  name: 'access-log-video-proxies'
  access_log_name: 'access.log'

push_client:
  clean_push_client_configs: True
  port: 8088
  send_delay: 10
  stats:
    - name: stat01d
      logger: { remote: 0 }
    - name: stat01f
      logger: { remote: 0 }
  logs:
    - file: nginx/access.log
    - file: nginx/error.log
    - file: yandex/video/proxy.log

nginx-config-files:
  - nginx/common/proxy_get_mds.conf
  - nginx/common/rewrite_to_mds.conf
  - nginx/conf.d/02-proxycache.conf
  - yandex/proxy/10-video-proxy.conf

nginx-sites-enabled:
  10-video-proxy.conf: /etc/yandex/proxy/10-video-proxy.conf
