/usr/bin/media-backup.sh:
  file.managed:
    - source: salt://files/backup/usr/bin/media-backup.sh
    - user: root
    - group: root
    - mode: 755

{% for dir in 'mongodb','cassandra','mysql' %}
/opt/{{ dir }}/net/yandex:
  file.directory:
    - user: ftp
    - mode: 755
    - makedirs: True
{% endfor %}

/etc/init.d/proftpd:
  file.managed:
    - source: salt://files/backup/etc/init.d/proftpd
    - mode: 755

/etc:
  file.recurse:
    - source: salt://files/backup/etc
    - include_empty: True

/etc/init.d/yandex-rsync:
  file.managed:
    - mode: 755
    - makedirs: True
      contents: |
        #!/usr/bin/perl
        use Ubic::Run;

/etc/ubic/service/yandex-rsync:
  file.managed:
    - makedirs: True
      contents: |
        use strict;
        use Morpheus "yandex-rsync" => [qw($LOG_DIR $RSYNCD_CFG_FILE)];
        use Yandex::X;
        use base qw(Ubic::Service::SimpleDaemon);
        sub new {
            my ($class) = @_;
            return $class->SUPER::new({
                bin => "/usr/bin/rsync --no-detach --daemon --config $RSYNCD_CFG_FILE",
                stdout => "$LOG_DIR/process.log",
                stderr => "$LOG_DIR/process.err.log",
            });
        }
        sub start {
            my $self = shift;
            $self->SUPER::start();
        }
        return __PACKAGE__->new;
    - require:
      - pkg: ubic

ubic:
  pkg:
    - installed

/etc/logrotate.d/yandex-rsync:
  file.managed:
    - makedirs: True
      contents: |
        /var/log/yandex-rsync/*.log {
          rotate 5
          weekly
          nocompress
          nocreate
          missingok
          sharedscripts
        }

yandex-rsync-startup-links:
  cmd.wait:
    - name: update-rc.d -f yandex-rsync defaults
    - watch:
      - file: /etc/init.d/yandex-rsync

/var/log/yandex-rsync:
  file:
    - directory

rsync:
  service.running:
    - name: yandex-rsync
    - enable: True
    - watch:
      - file: /etc
      - file: /etc/init.d/yandex-rsync
    - require:
      - file: /var/log/yandex-rsync
      - file: /etc/logrotate.d/yandex-rsync
