{% set fqdn = salt['grains.get']('fqdn') %}

first_update:
  cmd.run:
    - order: 1
    - name: apt-get update && apt-get dist-upgrade -y

base_packages:
  pkg.installed:
    - order: 2
    - pkgs:
      {%- if '.qa.video.yandex.' in grains['fqdn'] %}
      - yandex-environment-qa
      {%- elif '.vd.yandex.' in grains['fqdn'] %}
      - yandex-environment-testing 
      - yandex-conf-repo-testing
      - yandex-conf-repo-prestable
      - yandex-crossdomain-xml-testing
      {%- else %}
      - yandex-environment-production
      - yandex-crossdomain-xml-production
      {% endif %}

config_media_common:
  pkg.installed:
    - order: 3
    - pkgs:
      - config-media-common
      - salt-yandex-components
