{% for conf in "logrotate.d/nginx-tskv","nginx/conf.d/01-accesslog-tskv.conf" %}
/etc/{{ conf }}:
  file.managed:
    - makedirs: True
    - source: salt://files/common/etc/{{ conf }}
    - template: jinja
{% endfor %}

/usr/sbin/media_tskv_parser.pl:
  file.managed:
    - source: salt://files/common/usr/sbin/media_tskv_parser.pl
    - user: root
    - group: root
    - mode: 755

nginx:
  service:
    - running
    - enable: True
    - restart: True
    - watch:
      - file: /etc/nginx/conf.d/*
