#!/bin/bash

if [ -f /etc/yandex/media-backup.conf ]; then
  . /etc/yandex/media-backup.conf
fi

myfqdn=`hostname -f`
if [ -z ${myfqdn} ]; then
  echo "Don't get hostname"
  exit 0
fi
project=`curl -m 3 -s "http://c.yandex-team.ru/api/hosts2projects/$myfqdn"`
if [[ $project == "" || $project == "No projects found" ]]; then
  echo "No projects found in C"
  exit 0
fi
if [ -z ${backup_group} ]; then
  backup_group="${project}-backup"
fi
mirror_backup_group="$backup_group-mirror"
if [ -z ${share} ]; then
  share="backup"
fi
if [ -z ${log_path} ]; then
  log_path="/var/log/media-backup/run.log"
fi
if [ -z ${backup_dir} ]; then
  backup_dir="/opt/"
fi
ts=`date +[%Y-%m-%d' '%H-%m-%S]`
backup_hosts=`/usr/bin/curl -m 3 -s http://c.yandex-team.ru/api/groups2hosts/$backup_group?fields=fqdn`
mirror_hosts=`/usr/bin/curl -m 3 -s http://c.yandex-team.ru/api/groups2hosts/$mirror_backup_group?fields=fqdn`

function sync_cache() {
  echo $1 > $2.tmp
  if [ -s $2.tmp ]; then
    mv $2.tmp $2
  fi
}

echo "$ts ============== Running ==============" >> $log_path
if [[ $backup_hosts != "" && $backup_hosts != "No groups found" ]]; then
  sync_cache $backup_hosts /tmp/backup_hosts.cache
  echo 'backup_hosts: '$backup_hosts >> $log_path
else
  echo "C group $backup_group is clean or not found" >> $log_path
  exit 0
fi
if [[ $mirror_hosts != "" && $mirror_hosts != "No groups found" ]]; then
  sync_cache $mirror_hosts /tmp/mirror_hosts.cache
  echo 'mirror_hosts: '$mirror_hosts >> $log_path
else
  echo "C group $mirror_backup_group is clean or not found" >> $log_path
  exit 0
fi

if [ `grep -c $myfqdn /tmp/mirror_hosts.cache` -gt 0 ]; then
  echo "I'm mirror host ($myfqdn). Start backup" >> $log_path
  for i in $backup_hosts; do
    echo "Clonning $i" >> $log_path
    echo "------ start rsync log ------" >> $log_path
    /usr/bin/rsync -rlHpogDtv --delete --timeout=100 rsync://"$i"/$share/ $backup_dir >> $log_path
    echo "------ end rsync log ------" >> $log_path
  done
  echo "Done." >> $log_path
else
  echo "I'm ($myfqdn) not mirror host. Exit" >> $log_path
  exit 0
fi
