#!/usr/bin/perl

use strict;
use Data::Dumper;
use Getopt::Long;

my $metrics = {};

my $myvhost;
my $myreq;
GetOptions('host=s' => \$myvhost,'req=s' => \$myreq);

while (<STDIN>) {
  $_ =~ m/(tskv\t
           tskv_format=.*(\t)?
           timestamp=\d\d\d\d-\d\d-\d\dT:\d\d:\d\d:\d\d(\t)?
           timezone=\+\d\d\d\d(\t)?
           status=(?<status>\d\d\d)(\t)?
           protocol=(-||HTTP\/\d\.\d)(\t)?
           method=(-|OPTIONS|PUT|GET|POST|HEAD|CONNECT)(\t)?
           request=(?<request>(-|.*?))(\t)?
           referer=(-|.*?)(\t)?
           cookies=(-|.*?)(\t)?
           user_agent=(-|.*?)(\t)?
           vhost=(?<vhost>(-|.*?))(\t)?
           ip=.*?(\t)?
           x_forwarded_for=(-|.*?)(\t)?
           x_real_ip=(-|.*?)(\t)?
           request_time=(?<request_time>(-|\d+\.\d\d\d))(\t)?
           upstream_addr=(-|.*?)(\t)?
           upstream_status=(-|\d\d\d)(\t)?
           upstream_response_time=(?<upstream_response_time>(-|\d+\.\d\d\d))(\t)?
           request_id=.*\n)/ix;
  my $host = $+{vhost};
  my $req = $+{request};
  my $status = $+{status};
  my $uptime = $+{upstream_response_time};
  my $reqtime = $+{request_time};
  my $rand = rand();
  if (defined $myvhost && defined $myreq) {
    if ( $host =~ /$myvhost/ and $req =~ /$myreq/ ) {
      $metrics->{ $myvhost }->{ $req.$rand } =  { 
                    'status' => $status,
                    'upstream_time' => $uptime,
                    'request_time' => $reqtime,
                    };
    }
  } elsif (defined $myvhost && !defined $myreq ) {
     if ( $host =~ /$myvhost/ ) {
      $metrics->{ $myvhost }->{ $req.$rand } =  {  
                                        'status' => $status,
                                        'upstream_time' => $uptime,
                                        'request_time' => $reqtime,
                                        };
    }
  } elsif (!defined $myvhost && defined $myreq ) {
    if ( $req =~ /$myreq/ ) {
      $metrics->{ 'all' }->{ $req.$rand } =  {
                                        'status' => $status,
                                        'upstream_time' => $uptime,
                                        'request_time' => $reqtime,
                                        };
    }
  } elsif (!defined $myvhost && !defined $myreq ) {
    $metrics->{ 'all' }->{ $req.$rand } =  {
                                        'status' => $status,
                                        'upstream_time' => $uptime,
                                        'request_time' => $reqtime,
                                        };
  }
}

foreach my $vhost ( keys %$metrics ) {
  my @status;
  my @reqtime;
  my @uptime;
  for my $req ( keys %{$metrics->{ $vhost }} ) {
    push (@status,$metrics->{ $vhost }->{ $req }->{ 'status' });
    next if $metrics->{ $vhost }->{ $req }->{ 'upstream_time' } == '-';
    push (@uptime,$metrics->{ $vhost }->{ $req }->{ 'upstream_time' });
  }

  my @status_2xx = grep /^2/, @status;
  my @status_3xx = grep /^3/, @status;
  my @status_4xx = grep /^4/, @status;
  my @status_5xx = grep /^5/, @status;

  sub count{
    my @list = @_;
    my $fl = substr($list[0],0,1);
    if (length($list[0]) < 3) {
      print $fl."xx 0\n";
    } else {
      print $fl."xx ".scalar @list."\n";
    my %counts;
    $counts{$_}++ for @list;
    print map { "$_ $counts{$_}\n" } keys %counts;
    }
  }

  my $rps = @status;
  my @upstream_time = grep(s/\s*$//g, @uptime);
  print "total_rps $rps\n";
  if (!@status_2xx) {
    @status_2xx = ('2');
  }
  count(@status_2xx);
  if (!@status_3xx) {
    @status_3xx = ('3');
  }
  count(@status_3xx);
  if (!@status_4xx) {
    @status_4xx = ('4');
  }
  count(@status_4xx);
  if (!@status_5xx) {
    @status_5xx = ('5');
  }
  count(@status_5xx);
}
