#!/usr/bin/mawk -f
# use mawk because gawk slower than perl

function parse_fields(){
  if (!initialized){
    for (i=1;i<=NF;i++) {
      v_indexes[i]=index($i, "=")+1
      if ($i ~ /^vhost=/)                  vhost=i
      if ($i ~ /^request=/)                request=i
      if ($i ~ /^status=/)                 status=i
      if ($i ~ /^request_time=/)           request_time=i
      if ($i ~ /^upstream_response_time=/) upstream_response_time=i
      if ($i ~ /^upstream_cache_status=/)  upstream_cache_status=i
      if ($i ~ /^scheme=/)                 scheme=i
      if ($i ~ /^bytes_sent=/)             bytes_sent=i
      if ($i ~ /^referer=/)                referer=i
      if ($i ~ /^ssl_protocol=/)           ssl_protocol=i
      if ($i ~ /^ssl_cipher=/)             ssl_cipher=i
      if ($i ~ /^ssl_handshake_time=/)     ssl_handshake_time=i
      if ($i ~ /^ip=/)                     ip=i
      if ($i ~ /^args=/)                   args=i
    }
    tnames[upstream_response_time]="total_upstream_timings"
    tnames[request_time]="request_timings"
    tnames[ssl_handshake_time]="ssl_handshake_timings"
    initialized=1
  }
}

function v(num){
  return substr($num, v_indexes[num])
}

BEGIN {
  FS="\t"
}{
  parse_fields()

  tkn=split(v(args), atk, "errorcode=")
  if (tkn > 1) {
    code=substr(atk[tkn], 1, index(atk[tkn], "&")-1)
    errors[code]++

    if (v(args) ~ /app=player-translation/) {
      translation_errors[code]++
    }

    ptkn=split(v(referer), a, "login=")
    if (ptkn > 1) {
      if (a[tkn] ~ /^(ya-awaps|yaholiday|film-trailers|movie-trailers|ymaps|ya-events)/ ||
          a[tkn] ~ /^(ya-fishki|ya-ukraine-official|yacinema|platon|direct|podskazky1)/) {
        partners_errors[code]++
      }
    }
    if (match(atk[tkn], /host=[^&]+.yandex.net/) > 0) {
      alone_errors[substr(atk[tkn], RSTART+5, RLENGTH-5)"="code]++
    }
  }
} END {
  for (c in errors){
    print "common." c, errors[c]
  }
  for (c in partners_errors){
    print "partners." c, partners_errors[c]
  }
  for (c in translation_errors){
    print "translation." c, translation_errors[c]
  }
  for (c in alone_errors){
    value=alone_errors[c]
    gsub(/\./, "_", c)
    gsub(/=/, ".", c)
    print "alone." c, value
  }
}
