<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:template match="/daemon">

<fastcgi>
  <pools>
    <!-- <pool name="read"     threads="200"  queue="400"/> -->
    <pool name="read"     threads="1000"  queue="2000"/>
    <pool name="internal" threads="5"  queue="5"/>
  </pools>

  <handlers>
    <handler pool="read" url="/(get|getx|get-token)(/|$).*">
      <component name="proxy-video"/>
    </handler>
    <handler pool="internal" port="11000" url="/(get-internal)(/|$).*">
      <component name="proxy-video"/>
    </handler>

    <!-- proxy alive check -->
    <handler pool="read" url="/(ping-alive)(/|$).*">
      <component name="ping-alive"/>
    </handler>
    
  </handlers>

  <components>
    <!--video-->
    <component name="proxy-video" type="video:video-proxy">
      <logger>proxy-video-logger</logger>
      <auth>proxy-video-auth</auth>
      <storage-maps>/etc/fastcgi/storage-maps</storage-maps>
      <subnet-list><xsl:value-of select="/daemon/common/subnet-list"/></subnet-list>
      <storage-manager>storage-manager</storage-manager>
     <!-- <check-timeout>1</check-timeout> -->
    </component>
    <!--storage-manager-->
    <component name="storage-manager" type="storage-manager:manager">
      <open-storages>/etc/fastcgi/storage-maps/open-storages</open-storages>
      <logger>proxy-video-logger</logger>
      <storage-maps>/etc/fastcgi/storage-maps</storage-maps>
      <subnet-list>b</subnet-list>
      <check-timeout>3</check-timeout>
    </component>    
    <!--loggers-->
    <component name="daemon-logger" type="logger:logger">
      <!-- <level>DEBUG</level> -->
      <level>INFO</level>
      <!--
      <file>/var/log/fastcgi/proxy-video.daemon.log</file>
      <control-uri>/log</control-uri>
      <pattern>[%d %p] %m%n</pattern>
      -->
      <ident>daemon-logger-video</ident>
    </component>
    <component name="proxy-video-logger" type="logger:logger">
      <level>INFO</level>
      <!--
      <file>/var/log/fastcgi/proxy-video.trace.log</file>
      <control-uri>/image-processor-log</control-uri>
      <pattern>[%d %p] %m%n</pattern>
      -->
      <ident>image-storage-proxy-video</ident>
    </component>
    <component name="ping-alive" type="ping-alive:ok">
    </component>
  </components>

  <modules>
    <module name="video" path="/usr/lib/fastcgi-video-proxy.so"/>
    <module name="logger" path="/usr/lib/fastcgi/fastcgi-syslog.so"/>
    <module name="storage-manager" path="/usr/lib/fastcgi-storage-status.so"/>
    <module name="ping-alive"	   path="/usr/lib/fastcgi-always-ok.so"/> 
  </modules>
  <daemon>
    <reuse_monitor_port>yes</reuse_monitor_port>
    <logger component="daemon-logger"/>
    <endpoint>
      <backlog>128</backlog>
      <socket>/var/run/fastcgi/video-proxy.sock</socket>
      <threads>50</threads>      
    </endpoint>
    <pidfile>/var/run/fastcgi/video-proxy.pid</pidfile>
    <monitor_port>20091</monitor_port>
  </daemon>
</fastcgi>

  </xsl:template>
</xsl:stylesheet>
