#!/bin/bash
# logrotate -> for i in {7..1}; do l=.$[i-1];mv $rlogf{${l#.0},.$i}|&:;done;
# will be here as for normal people
##########
LOGFILE=/var/log/mcs-qa-restore.log
for i in {7..1}; do
   lnum=".$((i-1))" ; # from 0 but 0 will be strip on next line
   mv $LOGFILE${lnum#.0} $LOGFILE.${i}|&: # always success
done

exec 3<>$LOGFILE  # now open log
exec 1>&3         # stdout to log
exec 2>&1         # stderr to stdout to log =)
#########

DATE=`date`
echo "$DATE"
echo "Restore start"
YESTERDAY=`date +%Y%m%d`
HOSTNAME=`hostname -f`
PROJECT=`curl -m 3 -s "http://c.yandex-team.ru/api/hosts2projects/$HOSTNAME"`
HOST=`curl -m 3 -s http://c.yandex-team.ru/api/groups2hosts/${PROJECT}-backup?fields=fqdn`
rm -rf /var/tmp/backup_restore
echo "Download backup start"
/usr/bin/rsync -rlHpogDtv --timeout=100 rsync://$HOST/backup-mongodb/$PROJECT-mongodb-1/$YESTERDAY/*/config/* /var/tmp/backup_restore/
if [ $? -ne 0 ]; then
    echo "Download failed";
    exit;
fi
echo "Download complete"

for i in `ls /var/tmp/backup_restore/ | grep bson | cut -d . -f 1`; do
    mongorestore --port 27019 --drop --collection $i --db config /var/tmp/backup_restore/${i}.bson;
done

mongo --port 27019 config --eval "printjson(db.locks.remove({}))"
mongo --port 27019 config --eval "printjson(db.lockpings.remove({}))"
mongo --port 27019 config --eval "printjson(db.mongos.remove({}))"
mongo --port 27019 config --eval "printjson(db.shards.remove({}))"

for i in `seq 1 3`; do
    mongo --port 27019 config --eval "printjson(db.chunks.update({ "shard": \"video-mongodb-$i\" }, { \$set: { "shard": \"video-qa-mongodb-$i\" }}, { multi: true } ))"
    mongo --port 27019 config --eval "printjson(db.databases.update({ "primary": \"video-mongodb-$i\" }, { \$set: { "primary": \"video-qa-mongodb-$i\" }}, { multi: true } ))"
    mongo --port 27019 config --eval "printjson(db.shards.insert({ "_id": \"video-qa-mongodb-$i\", "host": \"video-qa-mongodb-$i/mongo0${i}.qa.video.yandex.net:27018\" }))"
done
echo "Restore complete"
exit 0
