#!/bin/bash
# logrotate -> for i in {7..1}; do l=.$[i-1];mv $rlogf{${l#.0},.$i}|&:;done;
# will be here as for normal people
##########
LOGFILE=/var/log/mongodb-restore.log
for i in {7..1}; do
   lnum=".$((i-1))" ; # from 0 but 0 will be strip on next line
   mv $LOGFILE${lnum#.0} $LOGFILE.${i}|&: # always success
done

exec 3<>$LOGFILE  # now open log
exec 1>&3         # stdout to log
exec 2>&1         # stderr to stdout to log =)
#########

log(){ echo "`date '+%F %T'`: $1"; }
conductor(){
   # conductor <method> <conductor_entity(host,grou i.e)> [cached]
   api="http://c.yandex-team.ru/api"
   until curl -sf "$api${3:+-cached}/$1/$2"; do
      if ((_r+=1, _r > ${MAX_CURL_RETRIES:=3})); then
         log "Failed to curl conductor #${MAX_CURL_RETRIES} times, exit!" >&2
         exit 1
      fi
   done
}
log "Restore start"
YESTERDAY=`date +%Y%m%d`
if [[ $1 =~ 201[0-9]{5} ]];then
      YESTERDAY=$1
fi
HOSTNAME=`hostname -f`
PROJECT=`conductor hosts2projects $HOSTNAME`
HOST=`conductor groups2hosts ${PROJECT}-backup`
HOST_NUMBER=`hostname -f|egrep -o '[1-9]'`

service mongodb stop; service mongos stop

log "Start to download backup"
if [ -e /var/tmp/backup_restore ];then
   log "CleanUp!"
   rm -rf /var/tmp/backup_restore
fi
until /usr/bin/rsync -aHv --timeout=200 --stats -h \
      rsync://$HOST/backup-mongodb/$PROJECT-mongodb-$HOST_NUMBER/$YESTERDAY/* \
         /var/tmp/backup_restore/; do
   if ((_r+=1, _r > ${MAX_RSYNC_RETRIES:=3})); then
      log "Failed to rsync dump (#${MAX_RSYNC_RETRIES} times)"; exit 1
   fi
   log "Rsync exited with non-zero code, trying again #$_r"
done
log "Download complete"

log "Deploy base"
set -x
rm -rf /opt/mongodb

tar xf <(pigz -dc /var/tmp/backup_restore/*/shard.dump.*.tar.gz) -C /opt
rm -rf /opt/mongodb/local.*
chown -R mongodb:mongodb /opt/mongodb
set +x
log "Deploy base complete"

service mongodb start;  service mongos start

log "Fix replica"
until mongo --port 27018 local --eval 'printjson(rs.initiate())'; do
   if ((_m+=1, _m>${MAX_MONGO_CONNECT_RETRIES:=5}));then
      log "mongo connection failed #${_m} times; exit!"; exit 1
   fi
   log "Sleep while mongo connection fails"; sleep 10;
done

mongo --port 27018 local --eval '
   printjson(db.system.replset.remove({})); printjson(db.slaves.remove({}));
   printjson(db.me.update({host: {"$regex": ".*"}},{host:"'$HOSTNAME'"}));
   printjson(db.system.replset.insert({_id:"'$PROJECT-qa-mongodb-$HOST_NUMBER'",
               version: 8, members: [{_id: 0, host: "'$HOSTNAME:27018'" }]}));

   for (i=0;i<60;i++){ if(!rs.isMaster().ismaster){
         print((new Date())+": Not a master, sleep.");sleep(1000)}
      else{print((new Date())+": Ok, is master, rewrie qa loader!");break}}

   if (rs.conf()._id.indexOf("mongodb-3") > 0) {
      printjson(db.getSisterDB("video_live_apps").upload_hosts.update(
         { "_id" : "up.qa.video.yandex.ru"}, { "enabled" : true,
           "freeSpaceMb" : NumberLong(10),         /* 7 days ago */
           "freeSpaceUpdate" : new Date(new Date() - 7*24*3600*1000),
           "loaderQueueSize" : 0 }, { upsert: true}))
   } else { printjson(db.getSisterDB("video_live_apps").upload_hosts.remove(
                                       {"_id": "up.qa.video.yandex.ru"}))
   }
   printjson(db.getSisterDB("video_live_apps").upload_hosts.update({
      _id:{$regex:"up0..\.video\.yandex\.ru"}},{
         "$set":{enabled:false}},{multi:true}))'

log "Delete tmp backup files"
set -x; rm -rf /var/tmp/backup_restore/; set +x
log "Restore complete"
exit 0
