#!/bin/bash
# logrotate -> for i in {7..1}; do l=.$[i-1];mv $rlogf{${l#.0},.$i}|&:;done;
# will be here as for normal people
##########
LOGFILE=/var/log/mysql-qa-restore.log
for i in {7..1}; do
   lnum=".$((i-1))" ; # from 0 but 0 will be strip on next line
   mv $LOGFILE${lnum#.0} $LOGFILE.${i}|&: # always success
done

exec 3<>$LOGFILE  # now open log
exec 1>&3         # stdout to log
exec 2>&1         # stderr to stdout to log =)
#########

DATE=`date`
echo "$DATE"
echo "Restore start"
YESTERDAY=`date +%Y-%m-%d`
HOSTNAME=`hostname -f`
PROJECT=`curl -m 3 -s "http://c.yandex-team.ru/api/hosts2projects/$HOSTNAME"`
BACKUP_HOST=`curl -m 3 -s http://c.yandex-team.ru/api/groups2hosts/${PROJECT}-backup?fields=fqdn`
SHOTNAME=`hostname -f | awk -F '-' {' print $1 '}`
echo "Download backup start"
/usr/bin/rsync -rlHpogDtv --timeout=100 rsync://$BACKUP_HOST/backup/mysql/net/yandex/$PROJECT/$SHOTNAME/$YESTERDAY/*${PROJECT}_${SHOTNAME}* /var/tmp/backup_restore/
if [ $? -ne 0 ]; then
    echo "Download failed";
    exit;
fi
echo "Download complete"
mysql -e "SET GLOBAL FOREIGN_KEY_CHECKS=0; drop database if exists video_$SHOTNAME; create database video_$SHOTNAME"
for i in `ls /var/tmp/backup_restore/`; do
    for i in `ls /var/tmp/backup_restore/ | grep video_$SHOTNAME | grep -v "video_$SHOTNAME-routines.sql.gz" | cut -d . -f 1-2`; do
        gunzip /var/tmp/backup_restore/$i.gz;
        echo "mysql -A video_view_counts < /var/tmp/backup_restore/$i;"
        mysql -A video_$SHOTNAME < /var/tmp/backup_restore/$i;
        rm /var/tmp/backup_restore/$i;
    done
done
mysql-grants-update -c
rm -rf /var/tmp/backup_restore
echo "Restore complete"
exit 0
