#!/usr/bin/env perl

use strict;
use warnings;
use Data::Dumper;
use List::Util 'sum';

my @partners = ('edu-platform','kinopoisk-trailers','ya-awaps','yaholiday',
                'ruscorpora-video','yndx-video','tborisow','ya-awaps2',
                'den-bkh','office-autoru','havr','testkur1','li0n192',
                'ya-expert','ya-ukraine-official','ya-events','film-trailers',
                'ymaps','ya-fishki','yacinema','platon','podskazky1','direct',
                'adv','csc-video','y-taxi2015','yamoney-video','zno-yndx',
                'zlobnyak','videoreview','yndx-sales-edu','yndx-ludmilakr',
                'disk-many-photos','afisha-trailers','ya-study-hr','yaerudit',
                'yndx-online-media','histrf','taxi-front','yatraffic',
                'ya-adfox');

my $bits = {};

while (<STDIN>) {
    foreach my $partner (@partners) {
        if ( $_ =~ m/request=.*$partner.*bytes_sent=([0-9]+).*/ ) {
            push @{$bits->{$partner}}, $1*8;
        }
    }
}

#print Dumper(%$bits);

while( my ($k, $v) = each %$bits ) {
    print "${k} " . sum (@{$v})."\n";
}
