#!/usr/bin/perl
# version 0.1
# (c) navigator@yandex-team.ru

if ($#ARGV != 3) {
    printf "\n  Usage: $0 <unit_id> <storage_id> <subnet_1> <subnet_2>\n";
    printf " Example 1: $0 17 01 d e\n";
    printf " Example 2: for i in `seq -w 00 29` 99; do $0 27 \$i e f; done;\n\n";
} else {
    $filename = "map$ARGV[0]$ARGV[1].xml";
    if ( -e $filename ){
        printf "file \"$filename\" already exists\n";
        exit (1);
    }
    open (MAP,">$filename") || die "can not open $filename: $!";
    printf MAP "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n";
    printf MAP "<map can-write=\"true\" key=\"woeiruty\">\n";
    printf MAP "  <mount-points>\n";
    printf MAP "    <mount-point id=\"1\" host=\"http://$ARGV[1].clip$ARGV[0]$ARGV[2].video.yandex.net\" port=\"10000\" subnet=\"$ARGV[2]\"/>\n";
    printf MAP "    <mount-point id=\"2\" host=\"http://$ARGV[1].clip$ARGV[0]$ARGV[3].video.yandex.net\" port=\"10000\" subnet=\"$ARGV[3]\"/>\n";
    printf MAP "  </mount-points>\n";
    printf MAP "  <buckets>\n";
    printf MAP "    <bucket master=\"1\" slave=\"2\"/>\n";
    printf MAP "    <bucket master=\"2\" slave=\"1\"/>\n";
    printf MAP "  </buckets>\n";
    printf MAP "</map>\n";

    close (MAP);

    printf "file $filename created\n";
    #exec ("cat $filename");

}


