include:
  - templates.certificates.YandexInternalCAs
  - templates.ipvs_tun

{%- set env = grains['yandex-environment'] %}

/etc/logrotate.d/xscript:
  file.managed:
    - source: salt://files/moderator/moderator.logrotate
    - makedirs: True
    - mode: 0644

/etc/syslog-ng/conf-available/xscript.conf:
  file.managed:
    - source: salt://files/moderator/xscript.syslog-ng
    - makedirs: True
    - mode: 0644

/etc/syslog-ng/conf-enabled/xscript.conf:
  file.symlink:
    - target: /etc/syslog-ng/conf-available/xscript.conf
    - makedirs: True
    - force: True

/etc/monrun/conf.d/xscript.conf:
  file.managed:
    - source: salt://files/moderator/xscript.conf
    - makedirs: True
    - mode: 0644

/etc/nginx/xscript:
  file.managed:
    - source: salt://files/moderator/xscript
    - makedirs: True
    - mode: 0644

/etc/nginx/sites-available/10-video-moderator.conf:
  file.managed:
    - source: salt://files/moderator/10-video-moderator.{{ env }}.conf
    - makedirs: True
    - mode: 0644

/etc/nginx/sites-available/00-common.conf:
  file.managed:
    - source: salt://files/moderator/00-common.conf
    - makedirs: True
    - mode: 0644

{%- for conf in '10-video-moderator.conf','00-common.conf' %}
/etc/nginx/sites-enabled/{{ conf }}:
  file.symlink:
    - target: /etc/nginx/sites-available/{{ conf }}
    - makedirs: True
    - force: True
{%- endfor %}

nginx_base:
  service.running:
    - name: nginx
    - enable: True
    - reload: True
    - watch:
      - file: /etc/nginx/xscript
      - file: /etc/nginx/sites-enabled/*.conf

{%- for script in 'iptesting','rejectex','rexscript' %}
/usr/sbin/{{ script }}:
  file.managed:
    - source: salt://files/moderator/{{ script }}
    - makedirs: True
    - mode: 0755
{%- endfor %}

/etc/xscript-multiple/conf-available/xscript-default:
  file.recurse:
    - source: salt://files/moderator/xscript-multiple
    - include_empty: True

/etc/xscript-multiple/conf-available/xscript-default/xscript.conf:
  file.symlink:
    - target: /etc/xscript-multiple/conf-available/xscript-default/xscript.{{ env }}.conf
    - makedirs: True
    - force: True

/etc/xscript-multiple/conf-enabled/xscript-default:
  file.symlink:
    - target: /etc/xscript-multiple/conf-available/xscript-default
    - makedirs: True
    - force: True

/etc/nginx/sites-enabled/20-video-proxy-to-services.conf:
  file.managed:
    - source: salt://files/nginx-admin/etc/nginx/sites-enabled/20-video-proxy-to-services.conf
    - makedirs: True
    - mode: 0644

