include:
  - disable_rp_filter

/etc/fastcgi:
  file.recurse:
    - source: salt://files/proxy/etc/fastcgi
    - include_empty: True
    - template: jinja

fastcgi_Makefile:
  file.managed:
    - name: /etc/fastcgi/templates/Makefile
    - source: salt://files/proxy/etc/fastcgi/templates/Makefile
  pkg.installed:
    - pkgs:
      - xsltproc
      - libxml2-utils
      - hostname
      - make
  cmd.wait:
    - name: make video-proxy
    - cwd: /etc/fastcgi/templates
    - watch:
      - file: fastcgi_Makefile
      - file: /etc/fastcgi/templates/*
    - require:
      - file: fastcgi_Makefile

/etc/nginx/ssl/https:
  file.managed:
    - source: salt://files/common/etc/nginx/ssl/https.tpl
    - makedirs: True
    - mode: 0644
    - template: jinja
    - context:
      cert: proxy.video.yandex.net.pem

{% if not salt.file.file_exists('/etc/nginx/common/video-villains.conf') %}
/etc/nginx/common/video-villains.conf:
  file.touch:
    - makedirs: True
{% endif %}

{% for conf in pillar.get('nginx-config-files') %}
/etc/{{ conf }}:
  yafile.managed:
    - makedirs: True
    - source: salt://files/proxy/etc/{{ conf }}
    - template: jinja
{% endfor %}

{% for site, path in pillar.get('nginx-sites-enabled').items() %}
/etc/nginx/sites-enabled/{{ site }}:
  file.symlink:
    - makedirs: True
    - target: {{ path }}
{% endfor %}

nginx:
  service:
    - running
    - enable: True
    - restart: True
    - watch:
      - file: /etc/nginx/conf.d/*
      - file: /etc/nginx/sites-enabled/*

{% for file in ['/etc/cron.d/config-video-proxy-temp-clean', '/etc/logrotate.d/fastcgi-video-proxy', '/usr/share/free_space_watchdog/nginx', '/usr/share/free_space_watchdog/quagga', '/etc/yandex/loggiver/loggiver.commands'] %}
{{ file }}:
  file.managed:
    - source: salt://files/proxy{{ file }}
    - makedirs: True
{% endfor %}

hcheck:
  file.managed:
    - name: /etc/hcheck/services.conf
    - source: salt://files/proxy/etc/hcheck/services.conf
  service:
    - running
    - enable: True
    - restart: True
    - watch:
      - file: /etc/hcheck/*

/usr/share/free_space_watchdog:
  file.recurse:
    - source: salt://files/proxy/usr/share/free_space_watchdog
    - include_empty: True

cert_expires:
  monrun.present:
    - execution_interval: 60
    - command: '/usr/lib/config-monrun-cert-check/cert_expires.sh' 
