{% set unit = 'video-all' %}

{% set config = pillar.get('free_space_trend', { 'execution_interval' : 60 , 'check_interval' : 300, 'prediction_intervals': 24, 'min_space_perc': 5 }) -%}
free_space_trend:
  monrun.present:
    - execution_interval: {{ config['execution_interval'] }}
    - execution_timeout: 15
    - command: /usr/bin/free_space_trend.sh {{ config['check_interval'] }} {{ config['prediction_intervals'] }} {{ config['min_space_perc'] }}

salt-minion:
  service.dead:
    - enable: False

{% for file in pillar.get(unit + '-files') %}
{{file}}:
  yafile.managed:
    - source: salt://files/{{ unit }}{{ file }}
    - mode: 644 
    - user: root
    - group: root
    - makedirs: True
    - template: jinja
{% endfor %}


{% for file in pillar.get(unit + '-scripts') %}
{{file}}:
  yafile.managed:
    - source: salt://files/{{ unit }}{{ file }}
    - mode: 755 
    - user: root
    - group: root
    - makedirs: True
    - template: jinja
{% endfor %}

{% for pkgname in pillar.get(unit + '-packages') %}
{{pkgname}}:
  pkg.installed
{% endfor %}


/etc/yandex/selfdns-client/default.conf:
  file.managed:
    - source: salt://files/video-all/etc/yandex/selfdns-client/default.conf
    - mode: 440
    - user: root
    - group: selfdns
    - template: jinja
    - makedirs: True
    - require:
      - pkg: yandex-selfdns-client

disable-ipv6-privacy-extensions:
  file.absent:
    - name: /etc/sysctl.d/10-ipv6-privacy.conf
