{% for file in pillar.get('zk-conf-files') %}
{{file}}:
  yafile.managed:
    - source: salt://files/zk{{ file }}
    - mode: 644 
    - user: root
    - group: root
    - makedirs: True
    - watch_in: monrun-regenerate
{% endfor %}

/etc/yandex/zookeeper-video/jaas.conf:
  yafile.managed:
    - source: salt://files/zk/etc/yandex/zookeeper-video/jaas.conf
    - mode: 600 
    - user: video
    - group: video
    - makedirs: True
    - template: jinja

{% for file in pillar.get('zk-exec-files') %}
{{file}}:
  yafile.managed:
    - source: salt://files/zk{{ file }}
    - mode: 755
    - user: root
    - group: root
    - makedirs: True
{% endfor %}

yandex-zookeeper-video:
  service:
    - running
  pkg:
    - installed
