import os
from datetime import datetime, timedelta

import logging

logging.basicConfig(level=logging.INFO, format="[%(asctime)s] %(levelname)s %(name)s %(message)s")
logger = logging.getLogger(__name__)

from yql.api.v1.client import YqlClient

YQL_TOKEN = os.getenv("YQL_TOKEN")

query = """
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
use hahn;

--$yesterday = CAST(CurrentUtcDate() - Interval("P1D") AS String);
--$day = $yesterday;
--$day = '2022-07-22';
$day='%{day}';


$result_table_prefix = '//home/disk-stat/sre_tools/disk_admin_access/java/';
$result_table = $result_table_prefix || $day;
$result_scripts_table = $result_table_prefix || $day || '_script';
$result_sql_table = $result_table_prefix || $day || '_sql';

$java_default_logs = [
    '//logs/ydisk-dataapi-log',
    '//logs/ydisk-dataapi-worker-log',
    '//logs/ydisk-diskaxis-log',
    '//logs/ydisk-docviewer-web-log',
    '//logs/ydisk-download-stat-log',
    '//logs/ydisk-fotki-log',
    '//logs/ydisk-grelka-log',
    '//logs/ydisk-lenta-loader-log',
    '//logs/ydisk-lenta-worker-log',
    '//logs/ydisk-lenta-worker-log',
    '//logs/ydisk-log-reader-log',
    '//logs/ydisk-migrator-log',
    '//logs/ydisk-notes-log',
    '//logs/ydisk-notifier-log',
    '//logs/ydisk-orchestrator-api-log',
    '//logs/ydisk-orchestrator-worker-log',
    '//logs/ydisk-ps-billing-log',
    '//logs/ydisk-queller-log',
    '//logs/ydisk-smartcache-client-log',
    '//logs/ydisk-smartcache-worker-log',
    '//logs/ydisk-uaas-log',
    '//logs/ydisk-uploader-balancer-log',
    '//logs/ydisk-uploader-log',
    '//logs/ydisk-videostreaming-log',
    '//logs/ydisk-webdav-log',
    '//logs/ydisk-worker2-log',
    '//logs/ydisk-counters-api-log',
    '//logs/ydisk-event-loader-log',
    '//logs/ydisk-urlshortener-log',
    -- '//logs/telemost-backend-log',
    '//logs/telemost-conference-manager-log'
];

$action_regexp = Re2::Capture('Invoking action (?P<action>[\\\\S\\\\s]*) with parameters: {(?P<params>[\\\\S\\\\s]*)}, path parameters: {(?P<path_params>[\\\\S\\\\s]*)}');
$log_suffix = '/1d/' || $day;
$java_access_log_path = 'logs/ydisk-java-access-log' || $log_suffix;
$r_replace_regexp = Re2::Replace('\\r');
$replace_new_lines = ($message) -> {return $r_replace_regexp($message, '')};

$env_or_production = ($row, $prefix) -> {
    $env = TryMember($row, $prefix || 'env', Just(''));
    return if ($env is not null and $env in ('TESTING', 'PRESTABLE'), $env, 'PRODUCTION');
};

$java_admin_requests = (
    SELECT
        tskv_format, request, ycrid, rid, login, uid, logtime, headers, host
    FROM $java_access_log_path
    where
        rid <> '-'
        and request like '/z/%' and request not like '/z/r/%'
        -- через эти запросы сделаны некоторые графики, нужно переделать их
        and request not in ('/z/manager/bean/dataJetty/method/getThreadPoolTotalCount/invoke.json', '/z/celery-tasks.json', '/z/manager/bean/dataJetty/method/getThreadPoolIdleCount/invoke.json')
);

$query_regexp = Re2::Capture('(query|command)=\\\\[(?P<query>[\\\\S\\\\s]*)\\\\]');
$remove_query_wrapper = ($params) -> {return $query_regexp($params).query};
$sql_query_regexp = Re2::Capture('query=\\\\[(?P<query>[\\\\S\\\\s]*)\\\\], ds=\\\\[(?P<ds>[\\\\S\\\\s]*)\\\\]');

DEFINE ACTION $find_admin_requests($default_log_path) AS

    $admin_requests = (
        SELECT
        default.tskv_format as tskv_format,
        default.logtime as logtime,
        default.message as message,
        default.host as host,
        access.login as login,
        access.uid as uid,
        $env_or_production(JoinTableRow(), 'default.') as env,
        $action_regexp(message).action as action,
        $replace_new_lines($action_regexp(message).params) as params,
        $replace_new_lines($action_regexp(message).path_params) as path_params
    FROM $java_admin_requests as access
    right join $default_log_path as default on access.rid = default.rid and access.host = default.host --and access.ycrid = default.ycrid
    where
        default.class = 'r.y.co.a3.action.ActionDispatcher'
        and default.message like 'Invoking action%AdminPage%with parameters%'
    );

    insert into $result_table
    select * from $admin_requests;

    insert into $result_scripts_table
    select
        ar.*,
        $remove_query_wrapper(params) as query
    from $admin_requests as ar
    where
        env = 'PRODUCTION'
        and action ilike '%rhino%'
        and params is not null ;

    insert into $result_sql_table
    select
        ar.*,
        $sql_query_regexp(params).query as query,
        $sql_query_regexp(params).ds as ds,
    from $admin_requests as ar
    where
        env = 'PRODUCTION'
        and action ilike '%sql%'
        and params is not null ;

END DEFINE;


EVALUATE FOR $default_log_path IN $java_default_logs DO BEGIN
    DO $find_admin_requests($default_log_path || $log_suffix)
END DO;
"""


def run_yql(yql):
    client = YqlClient(token=YQL_TOKEN)
    request = client.query(yql, syntax_version=1)
    request.run()
    logger.info('YQL request run: %s' % request.share_url)


def main():
    day = os.getenv("DATE") or (datetime.today() - timedelta(days=1)).strftime('%Y-%m-%d')
    yql = query.replace('%{day}', day)
    run_yql(yql)


if __name__ == "__main__":
    main()
