#!/bin/bash

# Принимает на вход список хостов по одному в строке
# Генерирует команду для dns-client
# Пример вызова: echo disk-srv11e.disk.yandex.net | ./add_hosts_to_dns.sh _DISKNETS_ 564 IVA "--v4 --v6"

export MACRO="$1"
export VLAN="$2"
export DC="$3"
export ADDR_TYPES="$4"

while read HOST; do
    addresses=$(getip --macro $MACRO --vlan $VLAN --dc $DC $ADDR_TYPES --quiet | awk '{print $1}' | xargs echo)
    echo "add $HOST $addresses"
    dns-client --zone-update --expression "add $HOST $addresses"
done
