#!/usr/bin/python3
import argparse
import subprocess
import os

from build_python_scripts_common import yt_script_configs_map, YtScriptConfig

ARCADIA_PATH = os.environ.get('ARCADIA_PATH')


def get_real_path(path):
    if os.path.exists(path):
        return path
    return os.path.join(ARCADIA_PATH, path)


def run_ya_make(path):
    subprocess.run(f'{ARCADIA_PATH}/ya make {path}', shell=True, check=True)


def upload_to_yt(config):
    subprocess.run(f'yt write-file --proxy {config.yt_proxy} '
                   f'--executable {config.yt_path} < '
                   f'{os.path.join(config.path, config.result_file_name)}', shell=True, check=True)


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--path', help='Путь к директории с ya.make')
    parser.add_argument('--result_file_name', help='Имя результирующего файла после сборки')
    parser.add_argument('--yt_path', help='Путь в yt, где должен лежать файл')
    parser.add_argument('--yt_proxy', default='hahn', help='Кластер в yt')

    args = parser.parse_args()

    config = yt_script_configs_map.get(args.result_file_name)
    if not config:
        config = YtScriptConfig.from_args_parser(args)

    config.path = get_real_path(config.path)

    run_ya_make(config.path)
    upload_to_yt(config)

    print(f'file uploaded to https://yt.yandex-team.ru/{config.yt_proxy}/navigation?path={config.yt_path}')


if __name__ == '__main__':
    main()
