YA_MAKE_PROGRAM_NAME_PREFIX = '_PROGRAM('
YA_MAKE_PROGRAM_NAME_PREFIX_LEN = len(YA_MAKE_PROGRAM_NAME_PREFIX)


def get_result_file_name(path):
    with open(path + '/ya.make') as f:
        for line in f:
            start_ind = line.find(YA_MAKE_PROGRAM_NAME_PREFIX)
            if start_ind == -1:
                continue

            end_ind = line.find(')', start_ind)
            if start_ind + YA_MAKE_PROGRAM_NAME_PREFIX_LEN < end_ind:
                return line[start_ind + YA_MAKE_PROGRAM_NAME_PREFIX_LEN:end_ind]

    return path[path.rfind('/') + 1:]


class YtScriptConfig:
    def __init__(self, path, result_file_name, yt_path, yt_proxy=None):
        self.path = path
        self.result_file_name = result_file_name
        self.yt_path = yt_path
        self.yt_proxy = yt_proxy if yt_proxy is not None else 'hahn'

    @staticmethod
    def from_args_parser(args):
        if not args or not args.path or not args.yt_path:
            raise ValueError('path and yt_path must be specified')

        if not args.result_file_name:
            args.result_file_name = get_result_file_name(args.path)

        return YtScriptConfig(args.path, args.result_file_name, args.yt_path, args.yt_proxy)


yt_script_configs = [
    YtScriptConfig('disk/dataapi/backend/src/main/java/ru/yandex/chemodan/app/dataapi/worker/importer/diff',
                   'dataapi_calculate_addresses_diff', '//home/datasync/addressesDiff/scripts/dataapi_calculate_addresses_diff'),
    YtScriptConfig('disk/docviewer/src/main/java/ru/yandex/chemodan/app/docviewer/cleanup/bazinga/documents',
                   'collect_documents_by_access_time', '//home/mpfs-stat/docviewer/documents-cleanup-root/scripts/collect_documents_by_access_time'),
    YtScriptConfig('disk/docviewer/src/main/java/ru/yandex/chemodan/app/docviewer/cleanup/bazinga/images',
                   'collect_images_by_access_time', '//home/mpfs-stat/docviewer/images-cleanup-root/scripts/collect_images_by_access_time'),
]

yt_script_configs_map = {config.result_file_name: config for config in yt_script_configs}
