#!/bin/bash
	
set -e 

sharpei_host='ds-sharpei02e.disk.yandex.net'

shard_prefix='datasync-'
sharddb='sharddb'

# Migration plan. 
# Format: <SOURCE>-<DEST>-<PERCENT>
# Example: 40-46-25 ->> Migrate 25% of users FROM shard 40 TO shard 46
plans='
40-46-25
42-47-25
44-48-20
'

sharpei_exec(){
  echo $@ | ssh ${sharpei_host} -- /bin/bash -s
}

sharpei_psql(){
  request=$1
  echo "$request" | ssh ${sharpei_host} sudo -i psql ${sharddb}
}

cat << EOF
---- WARNING ----
    DON'T FORGET TO EDIT THIS SCRIPT BEFORE LAUNCHING IT!
    If you did not edit this script, it will create some random migration you don't need.
    It's totally safe (this script does not change anything), but it's most probably not something, you want.
    If you did not edit this script before launching, or following plan is not what you want, please press Ctrl+C now

Sharpei host: ${sharpei_host}
Shards prefix: ${shard_prefix}
Plans: ${plans}

If everything looks good to you, press Enter.
EOF
read -r

echo "Checking connection..."

sharpei_exec "sudo -i echo 'Hello!, $(id -a)'"
# Create plans
	
# Sample request:
#  COPY(WITH dst_shards AS (SELECT shard_id FROM shards.shards WHERE name = 'datasync-48') SELECT FORMAT('uid=%s',users.uid),FORMAT('shard=%s',dst_shards.shard_id) FROM shards.users, dst_shards WHERE users.shard_id = (SELECT shard_id FROM shards.shards WHERE name = 'datasync-44') AND RANDOM() <= 0.20) TO '/tmp/filename';

echo "Creating user lists for each shard in plan..."
for plan in $plans ; do
    read -r src dst prc << EOF
${plan//-/ }
EOF
    echo "Moving ${prc}% from ${dst} to ${prc}..."
    request="COPY(WITH dst_shards AS (SELECT shard_id FROM shards.shards WHERE name = '${shard_prefix}${dst}') SELECT FORMAT('uid=%s',users.uid),FORMAT('shard=%s',dst_shards.shard_id) FROM shards.users, dst_shards WHERE users.shard_id = (SELECT shard_id FROM shards.shards WHERE name = '${shard_prefix}${src}') AND RANDOM() <= 0.${prc}) TO '/tmp/migrate-${plan}'"
    echo "Request: ${request}"
    sharpei_psql "${request}"
done

plan_name="${shard_prefix}-migration"
echo "Compiling plan"
for plan in $plans ; do 
    plan_name="${plan_name}__${plan}"
done
plan_name="${plan_name}.txt"
echo "$plan_name"

# Clean plan file
sharpei_exec ":>${plan_name}"

# Concatenate files
for plan in $plans ; do 
    sharpei_exec "cat /tmp/migrate-${plan} >> ~/${plan_name}-unshuffled"
done
sharpei_exec "shuf ${plan_name}-unshuffled > ${plan_name}"
scp "${sharpei_host}:${plan_name}" ./
