#/bin/bash

shard=$1
if [ -z $shard ]; then
	echo "Pass datasync shard number";
	exit 1;
fi
instances=`yc postgresql hosts list --cluster-name datasync-$shard`

#select code.add_shard('datasync-41', 'man-qpzx5rx91r4sv35p.db.yandex.net', 6432, 'man', 'api_disk_data_41');   
#select code.add_instance('man-qpzx5rx91r4sv35p.db.yandex.net', 'sas-uw7o97iyrwwbrxvz.db.yandex.net', 6432, 'sas', 'api_disk_data_41');

master_host=$(echo "$instances" | grep MASTER | awk '{print $2}' )

echo "begin;"
echo "$instances" | grep MASTER | awk "{printf(\"select code.add_shard('datasync-$shard', '%s', 6432, '%s', 'api_disk_data_$shard');\n\", \$2, \$10)}"
echo "$instances" | grep REPLICA | awk "{printf(\"select code.add_instance('$master_host', '%s', 6432, '%s', 'api_disk_data_$shard');\n\", \$2, \$10)}"
echo "commit;"

