#!/bin/bash

shard=$1
if [ -z "$shard" ]; then
	echo "Pass diskdb shard number";
	exit 1;
fi
instances=$(yc postgresql hosts list --cluster-name "diskdb${shard}")

master_host=$(echo "$instances" | grep MASTER | awk '{print $2}' )

echo "begin;"
echo "$instances" | grep 'MASTER' | awk "{printf(\"select code.add_shard('diskdb${shard}', '%s', 6432, '%s', 'diskdb_${shard}');\n\", \$2, \$10)}"
echo "$instances" | grep 'REPLICA ' | awk "{printf(\"select code.add_instance('$master_host', '%s', 6432, '%s', 'diskdb_${shard}');\n\", \$2, \$10)}"
echo "commit;"
