#!/usr/bin/python

import operator
import sys
from multiprocessing.pool import ThreadPool

import requests


class ConductorAPI(object):
    def __init__(self, url):
        self.url = url

    def _request(self, url, key):
        r = None
        for try_req in range(3):
            r = requests.get('%s%s/%s' % (self.url, url, key), params={'format': 'json'})
            if r.status_code == 200:
                break
        else:
            raise Exception('Bad answer %s %s' % (key, r.text))
        return r.json()

    def list_hosts(self, group_name):
        r = self._request('groups2hosts', group_name)
        return map(operator.itemgetter('fqdn'), r)

    def host_info(self, hostname):
        return self._request('host_info', hostname)

    def get_ips(self, group_name):
        hosts = conductor.list_hosts(sys.argv[1])
        pool = ThreadPool(10)
        for host_info in pool.imap_unordered(conductor.host_info, hosts):
            ip4, ip6 = None, None
            if 'ip4' in host_info['addresses']:
                ip4 = host_info['addresses']['ip4']['address']
            if 'ip6' in host_info['addresses']:
                ip6 = host_info['addresses']['ip6']['address']
            yield ip6, ip4
        pool.close()
        pool.join()


if __name__ == '__main__':
    if len(sys.argv) < 2:
        print("Usage: %s <conductor_name>" % sys.argv[0])
        sys.exit(1)
    conductor = ConductorAPI('https://c.yandex-team.ru/api-cached/')
    ips4 = []
    for ip6, ip4 in conductor.get_ips(sys.argv[1]):
        print(ip6)
        if ip4:
            ips4.append(ip4)

    if ips4:
        print("# IP4")
        print("\n".join(ips4))
