#!/usr/bin/python
import json
import urllib2
import argparse
from urllib import urlencode
from urlparse import urljoin


def gr_datapoints(metrics_root, from_t, until_t,
                  host='https://gr-mg.yandex-team.ru', url='render', base='media.disk.combaine', gr_format='json'):

    request_opts = {'target': '{}.{}'.format(base, metrics_root),
                    'from': from_t,
                    'until': until_t,
                    'format': gr_format}

    query_opts = urlencode(request_opts)
    request_url = '{}?{}'.format(urljoin(host, url), query_opts)
    graphite_raw_data = urllib2.urlopen(request_url).read()
    graphite_datapoints = json.loads(graphite_raw_data)[0]['datapoints']
    return graphite_datapoints


def data_paths(metahost, metrics_base, dc_list, metrics_list):
    data_paths = []
    for metrics in metrics_list:
        for dc in dc_list:
            gr_path = '{}_{}.{}.{}'.format(metahost, dc, metrics_base, metrics)
            razladki_path = '{}-{}_{}'.format(metahost.replace('_', '.'), dc, metrics)
            data_paths.append({'razladki': razladki_path,
                               'gr': gr_path})
        # appeding paths for summary stats
        gr_path_sum = '{}.{}.{}'.format(metahost, metrics_base, metrics)
        razladki_path_sum = '{}_{}'.format(metahost.replace('_', '.'), metrics)
        data_paths.append({'razladki': razladki_path_sum,
                           'gr': gr_path_sum})
    return data_paths


def gr2razladki_point(razladki_target, data_point):
    if not isinstance(data_point[0], float) or not isinstance(data_point[1], int):
        raise ValueError('wrong values in input data {}'.format(repr(data_point)))
    return {'param': razladki_target, 'ts': data_point[1], 'value': data_point[0]}


def get_batch(input_list, batch_size):
    for i in xrange(0, len(input_list), batch_size):
        batch = input_list[i:i + batch_size]
        yield batch


def yes_or_no(question):
    while "the answer is invalid":
        reply = str(raw_input(question+' (y/n): ')).lower().strip()
        if reply[0] == 'y':
            return True
        if reply[0] == 'n':
            return False


if __name__ == "__main__":
    """
    ./gr2razladki.py  --metahost dataapi_disk_yandex_net --base dataapi_nginx --from 20171201 --to 18:30_20171205
    """

    DC_LIST = ['sas',
               'iva',
               'myt']

    METRICS_LIST = ['2xx',
                    '3xx',
                    '4xx',
                    '5xx']

    RAZLADKI_POST_URL = 'https://launcher.razladki-test.yandex-team.ru/save_new_data_json/disk'

    parser = argparse.ArgumentParser()
    parser.add_argument('--metahost', required=True, dest='combine_metahost')
    parser.add_argument('--base', required=True, dest='combine_metrics_base')
    parser.add_argument('--from', required=True, dest='t_from')
    parser.add_argument('--to', required=True, dest='t_until')
    args = vars(parser.parse_args())

    combine_metahost = args['combine_metahost']
    combine_metrics_base = args['combine_metrics_base']
    t_from = args['t_from']
    t_until = args['t_until']

    # Generate gr and razladki points paths
    datasources_paths = data_paths(combine_metahost, combine_metrics_base, DC_LIST, METRICS_LIST)

    # iterate over all gr dapasource paths
    for datasource_path in datasources_paths:
        print datasource_path

        # fetching data from gr
        gr_data = gr_datapoints(datasource_path['gr'], t_from, t_until)

        # converting gr points to razladki points
        for batch in get_batch(gr_data, 3000):
            razladki_data = []
            for point in batch:
                try:
                    razladki_data.append(gr2razladki_point(datasource_path['razladki'], point))
                except ValueError as e:
                    print e.message
            print 'razladki_len', len(razladki_data)

            # generating and uploading json with points to razladki
            razladki_json = json.dumps({'data': razladki_data, 'override': True})
            urllib2.urlopen(RAZLADKI_POST_URL, razladki_json)
