# -*- coding: utf-8 -*-
import argparse
import os
import stat_from_db
import logging
import json
from google.protobuf import text_format
from rtc.mediator.config.config_pb2 import Config

INTERESTING_TARGETS = [
    'ydb.resolver.DiscoveryEndpointsResolver',
    'ydb.connection',
]

if __name__ == '__main__':
    parser = argparse.ArgumentParser(
        formatter_class=argparse.RawDescriptionHelpFormatter,
        description="""\033[92mMediator YDB stats collector.\x1b[0m\n""")
    parser.add_argument("-v", '--verbose', default=False, action='store_true')

    args = parser.parse_args()

    if args.verbose:
        for target in INTERESTING_TARGETS:
            logger = logging.getLogger(target)
            logger.addHandler(logging.StreamHandler())
            logger.setLevel(logging.DEBUG)

    config = Config()
    with open(os.environ.get('MEDIATOR_CONFIG_PATH', '/etc/mediator/mediator.conf'), 'r') as f:
        text_format.Parse(f.read(), config)

    r = stat_from_db.run(
        config.YDB.Endpoint,
        config.YDB.Database,
    )
    print(json.dumps(r))
