#!/bin/bash

# Принимает на stdin список хостов в OpenStack и reboot-ает их
IFS=',' read -ra HOSTS

for HOST in "${HOSTS[@]}"; do
    case $HOST in
        *"h.disk.yandex.net")
            region=sas;;
        *"f.disk.yandex.net")
            region=myt5;;
        *"e.disk.yandex.net")
            region=iva6;;
        *)
            echo "Unknown hostname";;
    esac
    if [ "$region" ]; then
        nova --os-region=$region reboot $HOST
    fi
done
