#!/bin/bash

# Принимает на вход список хостов по одному в строке
# Удаляет хост с адресами из dns
# Пример вызова: echo disk-srv11e.disk.yandex.net | ./remove_hosts_from_dns.sh

while read HOST; do
    echo "*** $HOST ***"
    addresses=$(host $HOST | awk '{a = a" "$(NF)} END {print a}')
    dns-client --zone-update --expression "delete $HOST $addresses" || dns-client --zone-update --expression "delete-a $HOST $addresses"
done
